#ifndef _KPUISSANCE4_H_
#define _KPUISSANCE4_H_

#include <ktmainwindow.h>
#include <qlabel.h>
#include <qsplitter.h>
#include <qmultilinedit.h>
#include <kprocess.h>
#include <qlineedit.h>

#include "playerboard.h"

enum PlayerType { Computer, Human};
enum LevelType { Easy, Medium, Hard};

class KPuissance4 : public KTMainWindow
{
	Q_OBJECT;

public:
	KPuissance4(QWidget *parent = 0, const char *name = 0);
	~KPuissance4();

protected:
	void initToolBar();
	void initMenuBar();
	void initStatusBar();
	void initView();

	bool queryClose();
	void readConfig(KConfig *);
	void saveConfig(KConfig *);

protected slots:
	void newGame();
	void openGame();
	void saveGame();
	void quitGame();
	void configure();
	void undo();
	void hint();
	void showHelp();
	void slotMessage(const char *text);
	void startServer();
	void connectToServer();
	void disconnect();
	void serverExited(KProcess *);
	void messageSend();
	void saveOptions();
	void createComputer();

protected:
	PlayerBoard	*Board;
	QSplitter	*Splitter, *Splitter2;
	QMultiLineEdit	*MessageWindow;
	BoardOptionsStruct	BoardOptions;
	KProcess	*ServerProcess;
	QLineEdit	*Message;
};

#endif
