/***************************************************************************
                          dlgoptionpreferences.h
                           -------------------
    description          : Preferences Dialog Class
    begin                : Sat Sep 11 1999
    copyright            : (C) 1999 by Stephan Uhlmann                         
    email                : suhlmann@gmx.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGOPTIONPREFERENCES_H
#define DLGOPTIONPREFERENCES_H

#include <qtabdialog.h>
#include <qpushbutton.h>

#include "dlgoptiongeneral.h"
#include "dlgoptionecho.h"
#include "dlgoptionmemory.h"
#include "dlgoptionsinput.h"
#include "dlgoptiontiming.h"

/**
  * Preferences Dialog Class
  * Tab-Dialog for the several option dialogs
  *@author Stephan Uhlmann
  */

class DlgOptionPreferences : public QTabDialog  {

	Q_OBJECT

public:
	/** constructor */
	DlgOptionPreferences(QWidget *parent=0, const char *name=0);
	/** destructor */
	~DlgOptionPreferences();


	/** returns true if keepLastinput QCheckBox is checked, else false */
	bool getKeepLastInput();
	/** returns true if AutoReconnect QCheckBox is checked, else false */
	bool getAutoReconnect();
	/** returns mode for local echo (0-off,1-on,2-auto) */
	int getLocalEchoMode();
	/** returns mode for input echo (0-off,1-on,2-auto) */
	int getInputEchoMode();
	/** returns max size for input history (lines) */
	int getInputSize();
	/** returns max size for output view (lines) */
	int getOutputSize();
	/** gets the autoreconnect timer start value */
	unsigned int getAutoTime();

	/** sets the autoreconnect timer start value */
	void setAutoTime(unsigned int t);
	/** check/unceck QCheckBox for option to keep the auto reconnect */
	void setAutoReconnect(bool);
	/** check/unceck QCheckBox for option to keep the last input */
	void setKeepLastInput(bool);
	/** set mode for local echo (0-off,1-on,2-auto) */
	void setLocalEchoMode(int);
	/** set mode for input echo (0-off,1-on,2-auto) */
	void setInputEchoMode(int);
	/** set max size for input history (lines) */
	void setInputSize(int);
	/** set max size for output view (lines) */
	void setOutputSize(int);

	/** gets the separator character */
	QString getSeparator();
	/** sets the separator character */
	void setSeparator(QString s);

	/** checks/unchecks useBeep */
	void setUseBeep(bool b);
	/** returns state of useBeep checkbox */
	bool getUseBeep();
	/** checks/unchecks outputNotify */
	void setOutputNotifyOn(bool b);
	/** gets status of outputNotify */
	bool getOutputNotifyOn();
	/** sets seconds to wait for output notification */
	void setOutputNotifySeconds(unsigned int sec);
	/** returns seconds to wait for output notification */
	unsigned int getOutputNotifySeconds();
  /** sets the character, that starts a speedwalking-sequence */
  void setSpeedwalkingChar (QString s);
  /** returns the character, taht starts a speedwalking-sequence */
  QString getSpeedwalkingChar();
  /** returns the external command char */
  QString getExternChar();
  /** set's the external command char */
  void setExternChar (QString externChar);
  /** sets the ConnectionTimeout */
  void setConnectTimeoutSeconds(unsigned int t);
  /** gets the ConnectionTimeout */
  unsigned int getConnectTimeoutSeconds();
  /** returns the status ofthe intelligent history feature */
  bool getIntelligentHistory();
  /**  */
  void setIntelligentHistory(bool i);
  /** enables or disables the keypad-macros */
  void setNumpadMacros(bool b);
  /** returns true if the Numpad-Macros are enabled */
  bool getNumpadMacros();
	/** enable or disable autoselect text in inputline on focus */
	void setSelectAllOnFocus(bool b);
	/** returns true if the SelectAllOnFocus-feature is enabled */
	bool getSelectAllOnFocus();

	
public slots:
	/**  slot called when OK button was clicked */
	void slotOKPressed();
	/**  slot called when default button was clicked */
	void slotDefaultPressed();

protected:

	DlgOptionGeneral* generalTab;
	DlgOptionEcho* echoTab;
	DlgOptionMemory* memoryTab;
	DlgOptionsInput* inputTab;
	DlgOptionTiming* timingTab;

	QPushButton *ok_Button;
	QPushButton *cancel_Button;
};

#endif


