/***************************************************************************
                          dlgoptioncolors.h
                         -------------------
    description          : Color Options Dialog Class
    begin                : Mon Sep 20 1999
    copyright            : (C) 1999 by Stephan Uhlmann
                                       Andre Alexander Bell
    email                : suhlmann@gmx.de
                           andre.bell@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef DLGOPTIONCOLORS_H
#define DLGOPTIONCOLORS_H

//Generated area. DO NOT EDIT!!!(begin)
#include <qwidget.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <kcolorbtn.h>
#include <kseparator.h>
//Generated area. DO NOT EDIT!!!(end)

#include <qdialog.h>
#include <qbuttongroup.h>
#include "../ansi.h"

/**
  * Color Options Dialog Class
  *@author Stephan Uhlmann, Andre Alexander Bell
  */

class DlgOptionColors : public QDialog  {
   Q_OBJECT
public:
	/** constructor */
	DlgOptionColors(QWidget *parent, const char *name, int i);
	/** destructor */
	~DlgOptionColors();

	/** returns QColor set as foreground color in KColorButton */
	QColor getForegroundColor();
	/** returns QColor set as background color in KColorButton */
	QColor getBackgroundColor();
	/** returns QColor set as local echo color in KColorButton */
	QColor getLocalEchoColor();

	/** sets the highlight color for DEBUG Interpret mode */
	void setDebugHighlightColor(QColor);
	/** gets the highlight color for DEBUG Interpret mode */
	QColor getDebugHighlightColor();
			
	/** return QColor set as ANSI standard colors */
	QColor getANSIColor(int ANSIColor);
	
	/** return QColor set as background colors */
	QColor getBgColor(int BgColor);
	
	/** sets the foreground KColorButton to the given QColor */
	void setForegroundColor(QColor);
	/** sets the background KColorButton to the given QColor */
	void setBackgroundColor(QColor);
	/** sets the local echo KColorButton to the given QColor */
	void setLocalEchoColor(QColor);

	/** sets the ANSI colors */
	void setANSIColor(int ANSIColor, QColor color);
	
	/** Sets the background colors */
	void setBgColor(int BgColor, QColor color);

public slots:
	/** slot for when DEFAULT is pressed */
	void slotDefaults();
	/** slot that reverses the colors */
	void slotReverse();
	/** slot that determines what colors to enable/disable based on Interpret type */
	void slotInterpretType();
  	
protected:
	/** initalizes Dialog (KDevelop generated) */
	void initDialog();
	//Generated area. DO NOT EDIT!!!(begin)
	QGroupBox *QGroupBox_3;
	QPushButton *ok_Button;
	QPushButton *cancel_Button;
	QGroupBox *mudWindowColor_GroupBox;
	QLabel *foreground_Label;
	KColorButton *foreground_KColorButton;
	KColorButton *background_KColorButton;
	QLabel *background_Label;
	QLabel *localEchoColor_Label;
	KColorButton *localEchoColor_KColorButton;
	QGroupBox *ansiColor_GroupBox;
	KColorButton *ansiBlack_KColorButton;
	KColorButton *ansiDarkRed_KColorButton;
	KColorButton *ansiDarkGreen_KColorButton;
	KColorButton *ansiDarkYellow_KColorButton;
	KColorButton *ansiDarkBlue_KColorButton;
	KColorButton *ansiDarkMagenta_KColorButton;
	KColorButton *ansiDarkCyan_KColorButton;
	KColorButton *ansiDarkWhite_KColorButton;
	KColorButton *ansiGray_KColorButton;
	KColorButton *ansiLightRed_KColorButton;
	KColorButton *ansiLightGreen_KColorButton;
	KColorButton *ansiLightYellow_KColorButton;
	KColorButton *ansiLightBlue_KColorButton;
	KColorButton *ansiLightMagenta_KColorButton;
	KColorButton *ansiLightCyan_KColorButton;
	KColorButton *ansiLightWhite_KColorButton;
	QLabel *black_Label;
	QLabel *darkRed_Label;
	QLabel *darkGreen_Label;
	QLabel *darkYellowD_Label;
	QLabel *darkBlue_Label;
	QLabel *darkMagenta_Label;
	QLabel *darkCyan_Label;
	QLabel *darkWhite_Label;
	QLabel *gray_Label;
	QLabel *lightRed_Label;
	QLabel *lightGreen_Label;
	QLabel *lightYellow_Label;
	QLabel *lightBlue_Label;
	QLabel *lightMagenta_Label;
	QLabel *lightCyan_Label;
	QLabel *lightWhite_Label;
	KSeparator *KSeparator_1;
	QPushButton *defaults_Button;
	QPushButton *Reverse_Button;
	KColorButton *debugHighlight_KColorButton;
	QLabel *debugHighlight_Label;
	KColorButton *bgBlack_Color;
	KColorButton *bgRed_Color;
	KColorButton *bgGreen_Color;
	KColorButton *bgYellow_Color;
	KColorButton *bgBlue_Color;
	KColorButton *bgMagenta_Color;
	KColorButton *bgCyan_Color;
	KColorButton *bgWhite_Color;
	QLabel *bgBlack_Label;
	QLabel *bgRed_Label;
	QLabel *bgWhite_Label;
	QLabel *bgCyan_Label;
	QLabel *bgMagenta_Label;
	QLabel *bgBlue_Label;
	QLabel *bgYellow_Label;
	QLabel *bgGreen_Label;
	//Generated area. DO NOT EDIT!!!(end)

private:
	/** The interpretation type */
	int iType;

};

#endif
