/***************************************************************************
                          dlgoptionmud.cpp
                      -------------------
    description          :
    begin                : Fri Nov 12 1999
    copyright            : (C) 1999 by Luke Ehresman
    email                : luke@usa.om.org                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include "dlgoptionmud.h"

DlgOptionMud::DlgOptionMud(KmudDoc* d, QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	setCaption(i18n("MUD Settings"));	

	mud = d->getMudProfile(d->current()->mudfile);
	mud->readData();		

	currentMUD_Label->setText(mud->getTitle());
    	
	interpretType_ButtonGroup = new QButtonGroup(this,"interpretType_ButtonGroup");
	interpretType_ButtonGroup->insert(iDefault_RB);
	interpretType_ButtonGroup->insert(iANSI_RB);
	interpretType_ButtonGroup->insert(iVT100_RB);
	interpretType_ButtonGroup->insert(iNone_RB);
	interpretType_ButtonGroup->insert(iDebug_RB);
	interpretType_ButtonGroup->hide();
	
	iType = mud->getInterpretationType();
	setInterpretType(iType);

	connect( ok_Button, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	connect( cancel_Button, SIGNAL(clicked()), SLOT(reject()) );
	connect( interpretType_ButtonGroup, SIGNAL(clicked(int)), SLOT(slotInterpretTypeChanged()) );
}

DlgOptionMud::~DlgOptionMud(){
}

void DlgOptionMud::setInterpretType(int a)
{
	mud->setInterpretationType(a);
	interpretType_ButtonGroup->setButton(a);
}

int DlgOptionMud::getInterpretType()
{
	return iType;
}

void DlgOptionMud::slotOKPressed()
{
	mud->writeData();
	accept();
}

void DlgOptionMud::slotInterpretTypeChanged()
{
	if (iDefault_RB->isChecked())
		iType = 0;
	else if (iANSI_RB->isChecked())
		iType = 1;
	else if (iVT100_RB->isChecked())
		iType = 2;
	else if (iNone_RB->isChecked())
		iType = 3;
	else if (iDebug_RB->isChecked())
		iType = 4;
	else
		iType = 0;

	mud->setInterpretationType(iType);
}
