/***************************************************************************
                          dlgmapoptionsmisc.cpp  -  description
                             -------------------
    begin                : Fri Sep 22 2000
    copyright            : (C) 2000 by John-Paul Stanford
    email                : john-paul.stanford@virgin.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "dlgmapoptionsmisc.h"

DlgMapOptionsMisc::DlgMapOptionsMisc(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	connect (chkValidRoom,SIGNAL(clicked()),SLOT(slotDoMoveCheckClicked()));
	connect (chkSpeedWalkLimit,SIGNAL(clicked()),SLOT(slotDoLimitSpeedWalkClicked()));
}

DlgMapOptionsMisc::~DlgMapOptionsMisc(){
}

void DlgMapOptionsMisc::setNoMoveString(QString str)
{ txtNoMove->setText(str); }

QString DlgMapOptionsMisc::getNoMoveString(void)
{ return txtNoMove->text(); }

void DlgMapOptionsMisc::setCanMoveString(QString str)
{ txtCanMove->setText(str); }

QString DlgMapOptionsMisc::getCanMoveString(void)
{ return txtCanMove->text(); }

void DlgMapOptionsMisc::setDoMoveCheck(bool set)
{
	chkValidRoom->setChecked(set);
	txtCanMove->setEnabled(set);
	txtNoMove->setEnabled(set);
	lblCanMove->setEnabled(set);
	lblNoMove->setEnabled(set);
}

void DlgMapOptionsMisc::setDoLimitSpeedWalk(bool set)
{
	chkSpeedWalkLimit->setChecked(set);
	txtAbortNum->setEnabled(set);
	lblNumMoves->setEnabled(set);
}

void DlgMapOptionsMisc::setSpeedWalkLimit(int numMoves)
{
	QString str;
	str.sprintf("%d",numMoves);
	txtAbortNum->setText(str);
}

int DlgMapOptionsMisc::getSpeedWalkLimit(void)
{
	bool OK;
	QString str(txtAbortNum->text());
	return str.toInt(&OK);
}

bool DlgMapOptionsMisc::getDoLimitSpeedWalk(void)
{ return chkSpeedWalkLimit->isChecked(); }

void DlgMapOptionsMisc::setDefaultTwoWay(bool set)
{ chkTwoWay->setChecked(set); }

bool DlgMapOptionsMisc::getDoMoveCheck(void)
{ return chkValidRoom->isChecked(); }

bool DlgMapOptionsMisc::getDefaultTwoWay(void)
{ return chkTwoWay->isChecked(); }

void DlgMapOptionsMisc::slotDoMoveCheckClicked(void)
{ setDoMoveCheck(chkValidRoom->isChecked()); }

void DlgMapOptionsMisc::slotDoLimitSpeedWalkClicked(void)
{
	setDoLimitSpeedWalk(chkSpeedWalkLimit->isChecked());
}