/* network_player.cpp
 *
 * Pieter Eendebak ( pte@ddsw.nl )
 *
 */

#include <stdio.h>

#include <qobject.h>
#include <qwidget.h>
#include <qsignal.h>

#include <kapp.h>
#include <kmsgbox.h>

#include "go.h"
#include "go_board.h"
#include "go_player.h"
#include "knetobject.h"
#include "network_player.moc"

KNetworkPlayer::KNetworkPlayer( KNetObject *n, bool c,
		KGoBoard *b, QWidget *parent,
		const char *name )
	: KGoPlayer( c, b, parent, name )
{
	netobject = n ;

	if ( n!=0 )
	{
		connect( netobject, SIGNAL(messageArrived()),
			this, SLOT(messageArrived()) ) ;
		connect( netobject, SIGNAL(connectionBroken()),
			this, SLOT(connectionBroken()) ) ;
	}
	else	debug("error: received null KNetObject") ;
}

KNetworkPlayer::~KNetworkPlayer()
{
}

void KNetworkPlayer::connectionBroken()
{
	// TODO: move this to better place
	KMsgBox::message(0, CAPTION,
		i18n("KNetworkPlayer: connection broken") ) ;
}

void KNetworkPlayer::messageArrived()
{
	int command ;
	char *message = netobject->getMessage() ;
	sscanf( message, "%3d", &command ) ;

	switch( command )
	{
		case MOVE:
		{
			int x, y ;
			sscanf( message, "%3d%3d%3d", &command, &x, &y ) ;
			printf("KNetworkPlayer: emitting move %d %d\n", x, y ); 			emit doMove( x, y ) ;
			break ;
		}
		case BOARDSIZE:
			// this is a hack to fix a problem
			// see network_client_receiver() in KGoWidget
			break;
		case QUITTING:
			// do something
			break ;
		default:
			debug("error: unknown message") ;
			break ;
	}
	

}

void KNetworkPlayer::opponentMoved( int x,int y )
{
	char *s = new char[MAX_MESSAGE_SIZE];
	snprintf( s, MAX_MESSAGE_SIZE, "%3d%3d%3d", MOVE, x, y ) ;
	printf("sending message: %s\n", s) ;
	netobject->sendMessage( s ) ;
}

void KNetworkPlayer::illegalMove( int, int )
{
	// TODO: implement
}

void KNetworkPlayer::playMove( int, int )
{
	// TODO: implement
} 

void KNetworkPlayer::boardSetup()
{
	// TODO: implement
}




