#ifndef KCHESS_H 
#define KCHESS_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <kapp.h>
#include <ktmainwindow.h>
 
#include "kchesswidget.h"

/**
 * This class serves as the main window for KChess.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Arun Sharma <adsharma@home.com>
 * @version 0.1
 */
class KChess : public KTMainWindow
{
	Q_OBJECT
public:
	/**
	 * Default Constructor
	 */
	KChess();

	/**
	 * Default Destructor
	 */
	virtual ~KChess();

public slots:
	/**
	 * This is called whenever the user Drag n' Drops something into our
	 * window
	 */
	void slotDropEvent(KDNDDropZone *);
 
protected:
	/**
	 * This function is called when it is time for the app to save its
	 * properties for session management purposes.
	 */
	void saveProperties(KConfig *);

	/**
	 * This function is called when this app is restored.  The KConfig
	 * object points to the session management config file that was saved
	 * with @ref saveProperties
	 */
	void readProperties(KConfig *);

private:
	KChessWidget *view;
};

#endif // KCHESS_H 
