#include "status_display.h"
#include <qframe.h>


StatusDisplay::
StatusDisplay(float bank_roll, char *help_text, QWidget *parent, 
              const char *name) : 
              QWidget( parent, name ), _bank_roll(bank_roll),
              _won(0), _lost(0), _push(0) {
   _num_hands = 0;
   _help_p = new QLabel(help_text, this, "help_display");
   _help_p->setAlignment(AlignCenter);
   _help_p->setFrameStyle(QFrame::Box | QFrame::Sunken);

   QString bank_roll_str;    
   bank_roll_str.sprintf("$%4.2f", _bank_roll);
   _bank_roll_p = new QLabel(bank_roll_str, this, "dollar_display");
   _bank_roll_p->setAlignment(AlignCenter);
   _bank_roll_p->setFrameStyle(QFrame::Box | QFrame::Sunken);

   _won_percent_p = new QLabel("Won 0%", this, "won_display");
   _won_percent_p->setAlignment(AlignCenter);
   _won_percent_p->setFrameStyle(QFrame::Box | QFrame::Sunken);

   _lost_percent_p = new QLabel("Lost 0%", this, "lost_display");
   _lost_percent_p->setAlignment(AlignCenter);
   _lost_percent_p->setFrameStyle(QFrame::Box | QFrame::Sunken);

   _push_percent_p = new QLabel("Push 0%", this, "push_display");
   _push_percent_p->setAlignment(AlignCenter);
   _push_percent_p->setFrameStyle(QFrame::Box | QFrame::Sunken);

   setMinimumSize(100, 100);
   resizeEvent(NULL);
}


void StatusDisplay::
resizeEvent(QResizeEvent *) {
   _help_p->setGeometry( 0, 0, width(), height()/5 );
   _bank_roll_p->setGeometry( 0, height() * 1/5, width(), height()/5 );
   _won_percent_p->setGeometry( 0, height() * 2/5, width(), height()/5 );
   _lost_percent_p->setGeometry( 0, height() * 3/5, width(), height()/5 );
   _push_percent_p->setGeometry( 0, height() * 4/5, width(), height()/5 );
}


void StatusDisplay::
setHelp(const char *help_text) {
   _help_p->setText(help_text);
}


void StatusDisplay::
setResults(float mult, float bet) {
   QString text_str;
   _num_hands++;
   if (mult < 0)
      _lost++;
   else if (mult > 0)
      _won++;
   else
      _push++;

   adjustBankroll(mult, bet);
   
   text_str.sprintf("Won %3.1f%%", (float)_won/(float)_num_hands * 100.0);
   _won_percent_p->setText(text_str);

   text_str.sprintf("Lost %3.1f%%", (float)_lost/(float)_num_hands * 100.0);
   _lost_percent_p->setText(text_str);

   text_str.sprintf("Push %3.1f%%", (float)_push/(float)_num_hands * 100.0);
   _push_percent_p->setText(text_str);
}


void StatusDisplay::
adjustBankroll(float mult, float bet) {
   QString text_str;

   _bank_roll += bet * mult;
   text_str.sprintf("$%6.2f", _bank_roll);
   _bank_roll_p->setText(text_str);
}

