/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   
#ifndef OPTIONSDIALOG_H
#define OPTIONSDIALOG_H

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <kwizard.h>
#include <kslider.h>
#include <klined.h>

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "kpathselector.h"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/
#define HELP_SPEED  "kalax_speed.html"
#define HELP_PATH   "kalax_path.html"
#define HELP_CHEAT  "kalax_cheat.html"

/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

class KalaxConfigDialog: public KWizard
{
  Q_OBJECT

  public:
    KalaxConfigDialog( QWidget *parent = 0 );
    ~KalaxConfigDialog();
  
   

    // Configurable Values
    // -------------------
    // Speed
    unsigned int moveEnemyEveryTick;    // move the non flying enemies every n ticks
    KSlider *moveEnemyEveryTickSl;

    unsigned int timerInterval;         // timer in ms
    KSlider *timerIntervalSl;

    unsigned int spriteStepEnemy;       // enemy steps in pixel
    KSlider *spriteStepEnemySl;

    unsigned int spriteStepEnemyShot;   // enemy shot step in pixel
    KSlider *spriteStepEnemyShotSl;

    unsigned int spriteStepPlayerShot;
    KSlider *spriteStepPlayerShotSl;
  
    // file path
    QString flightPlanPath;             // path to flightplans
    KPathSelector *flightPlanPathPs;

    QString spritesPath;                // path to gamesprites
    KPathSelector *spritesPathPs;

    QString levelPath;                  // path to level definitions
    KPathSelector *levelPathPs;

    QString soundPath;                  // path to sound files
    KPathSelector *soundPathPs;  

    // Cheats
    unsigned int playerShipCount;
    KSlider *playerShipCountSl;      
    unsigned int maxPlayerShots;
    KSlider *maxPlayerShotsSl;
    unsigned int maxEnemyShots;
    KSlider *maxEnemyShotsSl;
    unsigned int maxEnemys;
    KSlider *maxEnemysSl;
    unsigned int maxEnemyDestr;
    KSlider *maxEnemyDestrSl;

    virtual void show();

  public slots:
    virtual void writeConfig();
    virtual void readConfig();

    virtual void okBtnClicked();
    virtual void cancelBtnClicked();
    virtual void helpBtnClicked( int actPage );

  signals:
     void valuesChanged( );

  private:
     void getValues();
  protected:
};

#endif // OPTIONSDIALOG_H











