/***************************************************************************
                          field.h  -  description
                             -------------------
    begin                : Fri Dec 10 1999
    copyright            : (C) 1999 by Ralf-Christian Juergensen
    email                : ralf-christian.juergensen@stud.fh-flensburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FIELD_H
#define FIELD_H

#include "globals.h"

/** A field on a map.
  * It is owned by a player and has a value.
  * @author Ralf-Christian Juergensen
  */
class Field
{
public:
    
    /** Constructor */                    
    Field(Player p = NONE, Value v = EMPTY)
    {
        player = p;
        value = v;
    }
    		
    /**  To copy a field */
    Field& operator=(Field& field)
    {
        player = field.player;
        value = field.value;
        			
        return *this;
    }
    		
    void setPlayer(Player p)
    {
        player = p;
    }
    
    void setValue(Value v)
    {
        value = v;
    }
    
    Player getPlayer(void)
    {
        return player;
    }
    
    Value getValue(void)
    {
        return value;
    }

    /** Applies an AND on the fields value */    
    void and(bool b)
    {
        if(value < EMPTY)
        {
            if(b && value == ON)
            {
                value = ON;
            }
            else
            {
                value = OFF;
            }
        }
    }
    
    /** Applies an OR on the fields value */
    void or(bool b)
    {
        if(value < EMPTY)
        {
            if(!b && value == OFF)
            {
                value = OFF;
            }
            else
            {
                value = ON;
            }
        }
    }

    /** Applies an XOR on the fields value */    
    void xor(bool b)
    {
        if(value < EMPTY)
        {
            if(b && value == OFF)
            {
                value = ON;
            }
            else if(!b && value == ON)
            {
                value = ON;
            }
            else
            {
                value = OFF;
            }
        }
    }
		
private:
        
    Value value;
    Player player;
};

#endif // FIELD_H
