/***************************************************************************
                      StatistikDlg.cpp  -  statistics dialog class
                             -------------------                                         
    begin                : Sun Sep 19 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "StatistikDlg.h"
#include "StatistikPage.h"
#include "GenStatPage.h"
#include "langset.h"
#include "kvoctraindoc.h"
#include "resource.h"

#include <kapp.h>
#include "compat_2x.h"

#define Inherited QTabDialog

StatistikDlg::StatistikDlg
(
        LangSet         &langset,
        kvoctrainDoc    *doc,
        GradeCols       *gc,
	QWidget         *parent,
	const char      *name
)
	:
	Inherited( parent, name, true )
{
  setCaption( QString(KVOCTRAIN_TITLE) + i18n(": Document statistics") );

  GenStatPage *gspage = new GenStatPage (doc, this, name);
  addTab( gspage, i18n("General"));

  for (int i = 1; i < (int) doc->numLangs(); i++) {
    StatistikPage *spage = new StatistikPage (i, doc, gc, this, name);
    QString s = langset.findLongId(doc->getIdent(i));
    if (s.isEmpty() )
      s = doc->getIdent(i);
    else
      s = i18n(s);
    addTab( spage, s);
  }

  resize( 590+16,350+76 );
  setMinimumSize( 590+16,350+76 );
  setMaximumSize( 590+16,350+76 );
   setIcon (QPixmap (EA_KDEDATADIR("",  "kvoctrain/mini-kvoctrain.xpm" )));
}


StatistikDlg::~StatistikDlg()
{
}


void StatistikDlg::okButton()
{
  emit accept();
}
