/***************************************************************************
               QueryOptPage.cpp  -  query options dialogpage
                        -------------------
    begin                : Sat Jul 10 18:03:22 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef QueryOptPage_included
#define QueryOptPage_included

#include "QueryOptPageData.h"
#include "QueryManager.h"
#include "compat_2x.h" // string type macro 

class QueryOptPage : public QueryOptPageData
{
    Q_OBJECT

public:

    QueryOptPage
    (
        int           _mqtime,
        QueryManager *_manager,
        bool          swapdir,
        QWidget      *parent = NULL,
        const char   *name = NULL
    );

    virtual ~QueryOptPage();

    int  getMQueryTime()   const { return mqtime; }
    bool getSwapDir()      const { return swapdir; }

    void setStates(int _mqtime, bool _swapdir);

protected:
    void keyPressEvent( QKeyEvent * );

signals:
    void modifySetting(int = -1);

public slots:
    virtual void initFocus() const;

protected slots:
    virtual void slotChangeMQTime(EA_QTSTR);
    virtual void slotCheckSwap(bool);

protected:

    QValidator   *validator;
    QueryManager  manager;
    int           mqtime;
    bool          swapdir;
};
#endif // QueryOptPage_included
