/***************************************************************************
                 ProgressChart.cpp  -  display chart of query progress
                             -------------------                                         
    begin                : Thu Oct 28 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "ProgressChart.h"
#include <qpainter.h>

#include <iostream.h>

#define Inherited QFrame

ProgressChart::ProgressChart /*FOLD00*/
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name)
{
   all = 100;
   current = 0;
}


void ProgressChart::setData (int _all, int _current) /*FOLD00*/
{
  all = _all;
  current = _current;
}


void ProgressChart::paintEvent (QPaintEvent *pev) /*FOLD00*/
{
   QPainter chart (this);

   QString s, s2;
   s.setNum (all);
   s2.setNum (current);
   s += "/"+s2;

   int angle;
   if (current > 0 && all != 0)
     angle = (16 * 360)  * current / all;
   else
     angle = 0;

   chart.setBrush (darkYellow);
   QPen pen2 (darkGray, 1);
   chart.setPen (pen2);
   chart.drawPie (1, 1, width()-2, height()-2, 0, angle);
   if (angle != 0) {
     chart.setBrush (blue);
     chart.drawPie (1, 1, width()-2, height()-2, angle, 360*16-angle);
   }

   chart.setBrush (black);
   QPen pen (black, 3);
   chart.setPen (pen);
   chart.drawArc (1, 1, width()-2, height()-2, 0, 360*16);

   QFont ft = chart.font();
   ft.setWeight(QFont::DemiBold);
   chart.setFont(ft);
   chart.drawText (1, 1, width()-2, height()-2, AlignCenter, s);
}
