/***************************************************************************
                MCQueryDlg.h  -  multiple choice query dialog
                           -------------------
    begin                : Thu Nov 25 11:45:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef MCQuery_Dlg_H
#define MCQuery_Dlg_H

#include "MCQueryDlgData.h"

/* Library Includes */

#include <vector.h>

class kvoctrainExpr;
class kvoctrainApp;
class kvoctrainDoc;

class MCQueryDlg : public MCQueryDlgData
{
  Q_OBJECT

public:
	MCQueryDlg(QString org,
                   QString trans,
                   int entry,
                   int orgcol,
                   int transcol,
                   int query_cycle,
                   int query_num,
                   int query_startnum,
                   kvoctrainExpr *exp,
                   kvoctrainApp *kv_app,
                   kvoctrainDoc  *doc,
                   int mtime,
                   QWidget *parent=0,
                   char *name=0);
  
	virtual void setQuery(QString org,
                      QString trans,
                      int entry,
                      int orgcol,
                      int transcol,
                      int query_cycle,
                      int query_num,
                      int query_startnum,
                      kvoctrainExpr *exp,
                      kvoctrainApp *kv_app,
                      kvoctrainDoc  *doc,
                      int mtime);

public slots:
        virtual void initFocus() const;

protected:
        void keyPressEvent( QKeyEvent *e );

public slots:
        virtual void showItClicked();
        virtual void knowItClicked();
        virtual void dontKnowClicked();
        virtual void stopItClicked();
        virtual void optionsClicked();
        virtual void timeoutReached();
        virtual void editOrgClicked();
        virtual void editTransClicked();
        virtual void trans1clicked();
        virtual void trans2clicked();
        virtual void trans3clicked();
        virtual void trans4clicked();
        virtual void trans5clicked();
        virtual void verifyClicked();

protected:

  int            solution;
  vector<QRadioButton*> button_ref;
};

#endif // MCQuery_Dlg_H
