/***************************************************************************
                  ArtQueryDlg.h  -  query dialog for articles
                             -------------------
    begin                : Fri Dec 3 18:28:18 1999

    copyright            : (C) 1999,2000 by Ewald Arnold
    email                : ewald@ewald-arnold.de
 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ArtQueryDlg_included
#define ArtQueryDlg_included

#include "ArtQueryDlgData.h"
#include "GrammerManager.h"

class ArtQueryDlg : public ArtQueryDlgData
{
    Q_OBJECT

public:

    ArtQueryDlg(QString type,
                int entry,
                int col,
                int query_cycle,
                int query_num,
                int query_startnum,
                kvoctrainExpr *exp,
                kvoctrainApp  *kv_app,
                kvoctrainDoc  *doc,
                const Article &articles,
                int   mtime,
                QWidget *parent=0,
                char    *name=0);

    virtual void setQuery (QString type,
                int entry,
                int col,
                int query_cycle,
                int query_num,
                int query_startnum,
                kvoctrainExpr *exp,
                kvoctrainApp  *kv_app,
                kvoctrainDoc  *doc,
                const Article &articles,
                int   mtime);

    virtual ~ArtQueryDlg();

public slots:
    virtual void initFocus() const;

protected:
    void keyPressEvent( QKeyEvent *e );

protected slots:

    virtual void stopItClicked();
    virtual void showMoreClicked();
    virtual void showAllClicked();
    virtual void slotFemClicked();
    virtual void editClicked();
    virtual void knowItClicked();
    virtual void slotNaturalClicked();
    virtual void slotMaleClicked();
    virtual void dontKnowClicked();
    virtual void optionsClicked();
    virtual void verifyClicked();
    virtual void returnPressed();

    virtual void timeoutReached();

protected:

    Article   articles;

};
#endif // ArtQueryDlg_included
