/***************************************************************************
           PasteOptPage.h  -  clipboard options dialog page
                         -------------------
    begin                : Sun Jun 27 11:07:24 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef PasteOptPage_included
#define PasteOptPage_included

#include "PasteOptPageData.h"
#include <qstrlist.h>

class LangSet;
class kvoctrainDoc;

class PasteOptPage : public PasteOptPageData
{
    Q_OBJECT

public:

    PasteOptPage
    (
        QString       _sep,
        LangSet      &langset,
        QStrList     &list,
        kvoctrainDoc *doc,
        QWidget      *parent = NULL,
        const char   *name = NULL
    );

    QString  getSeparator ()   const { return sep; }
    QStrList getPasteOrder ();

    virtual ~PasteOptPage();

protected:
    void keyPressEvent( QKeyEvent * );

public slots:
    virtual void initFocus() const;

protected slots:
    virtual void slotSelectSep(int);
    virtual void slotItemDown();
    virtual void slotItemSkip();
    virtual void slotItemUp();
    virtual void slotCurrentDoc();
    void slotSyncLangSet(EA_QTSTR);

protected:

    QString       sep;
    LangSet      &langset;
    kvoctrainDoc *doc;
};
#endif // PasteOptPage_included
