/***************************************************************************
                   kvoctrain.cpp  - main part of kvoctrain
                             -------------------                                         
    begin                : Thu Mar 11 20:50:53 MET 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KVOCTRAIN_H
#define KVOCTRAIN_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qpainter.h>
#include <qcombobox.h>

// include files for KDE 
#include <kapp.h> 
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kiconloader.h>

#ifdef EA_KDE2x
#include <kmessagebox.h>
#else
#include <kmsgbox.h>
#endif

// application specific includes
#include "kvoctrainview.h"
#include "resource.h"
#include "langset.h"
#include "QueryManager.h"
#include "queryoption-dialogs/GroupOptPage.h"

class QTimer;
class KLined;
class ProgressDlg;
class QProgressBar;
class kvoctrainDoc;
class QueryDlgBase;
class CAboutDialog;

/**
  * This Class is the base class for your application. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. For the main view, an instance of class kvoctrainView is
  * created which creates your view.
  */
class kvoctrainApp : public KTMainWindow 
{
  Q_OBJECT

public:
  enum QueryType  { QT_Random, QT_Multiple,
                    QT_Articles, QT_Conjugation, QT_Comparison };

  /** construtor */
  kvoctrainApp(const char *name = 0);
  /** destructor */
  ~kvoctrainApp();
  /** returns true, if running in query mode now */
  bool isQueryMode() const
    { return querymode; }
  /** initMenuBar creates the menu_bar and inserts the menuitems */
  void initMenuBar();
  /** this creates the toolbars. Change the toobar look and add new toolbars in this
    * function */
  void initToolBar();
  /** setup the statusbar */
  void initStatusBar();
  /** setup the mainview*/
  void initView(const char *name);
  /** save the app-specific options on slotAppExit or by an Options dialog */
  void saveOptions(bool all);
  /** read the app-specific options on init() or by an Options dialog */
  void readOptions();
  /** saves the window properties for each open window during session end to the session config file, including saving the currently
  * opened file by a temporary filename provided by KApplication.
  * @see KTMainWindow#saveProperties
  */
  virtual void saveProperties(KConfig* );
  /** reads the session config file and restores the application's state including the last opened files and documents by reading the
  * temporary files saved by saveProperties()
  * @see KTMainWindow#readProperties
  */
  virtual void readProperties(KConfig* );

  /** enable menuentries/toolbar items */
  void enableCommand(int id_);
  /** disable menuentries/toolbar items */
  void disableCommand(int id_);
  void keyPressEvent( QKeyEvent *e );
  void keyReleaseEvent( QKeyEvent *e );
  /** add a opened file to the recent file list and update recent_file_menu
		*/
  void addRecentFile(const char* file);

 signals:
  void progressChanged (kvoctrainDoc *, int curr_percent);

 public slots:
  void slotVSliderTrackInfo (int value);
  void slotVSliderPressed (bool state, int val);

  /** edit an entry */
  bool slotEditEntry(int row, int col);

  /** select an entry */
  void slotSelectEntry(int row, int col, int key_state);
  void slotSaveSelection ();
  void slotCancelSelection ();
  void slotSelectAll();
  void slotProgress(kvoctrainDoc*,int);
  void slotResumeSearch(EA_QTSTR);
  void slotSearchNext();
  void slotInitSearch();
  void slotCreateLesson(int header);
  void slotCleanVocabulary ();
  void slotChooseLesson(int id);
//  void slotSearchClip();
  void slotModified ();
  void slotSetHeaderProp (int header_and_id);
  void slotHeaderCallBack (int cmd_and_id);
  void slotHeaderStatus (int cmd_and_id);
  void slotHeaderMenu(int header);
  void slotTagEntry(int row, int col, int key);
  void slotCellMoved(int row, int col, int keys);
  void showAboutDialog( void );
  void invokeHelp();
  /** append language to table */
  void slotAppendLang();
  /** exit query mode */
  void slotStopQuery(bool show_view);
  bool queryClose();
  /** overloaded for Message box on last window exit */
  bool queryExit();
  /** set up options */
  void slotGeneralOptions();
  void slotQueryOptions();
  void slotSaveOptions();
  void slotDocProps();
  void slotShowStatist();
  void slotCreateRandom();
  /** setup edit submenu */
  void aboutToShowEdit();
  void aboutToShowVocabulary();
  void aboutToShowLearn();
  /** setup file submenu */
  void aboutToShowFile();
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection */
  void statusCallback(int id_);
  /** starts random query mode */
  void slotRestartQuery();
  void slotStartSpecial(int col, QString type);
  void slotStartQuery(QString trans, QString org);
  void slotTimeOutBackup();

  void slotTimeOutRandomQuery();
  void slotTimeOutMultipleChoice();
  void slotTimeOutQuery();
  void slotTimeOutSpecial();

  /** open a new application window */
  void slotFileNew();
  /** open a document */
  void slotFileOpen();
  /** merge a document */
  void slotFileMerge();
  /** save a document */
  void slotFileSave();
  /** save a document under a different filename*/
  void slotFileSaveAs();
  void removeProgressBar ();
  void prepareProgressBar ();
  void fillLessonBox(kvoctrainDoc *the_doc);
  void loadDocProps(kvoctrainDoc *the_doc);
  void saveDocProps(kvoctrainDoc *);
  /** exits the application */
  void slotFileQuit();
  /* disconnect clipboard */
  void clipboardChanged();
  /** put the marked text/object into the clipboard*/
  void slotEditCopy();
  void slotSmartSearchClip();
  void slotAppendRow();
  void slotRemoveRow();
  void slotEditRow();
  /** paste the clipboard into the document*/
  void slotEditPaste();
  /** toggle the toolbar*/
  void slotViewToolBar();
  /** toggle the statusbar*/
  void slotViewStatusBar();
  /** change the status message to text */
  void slotStatusMsg(const char *text);
  /** change the status message of the whole statusbar temporary */
  void slotStatusHelpMsg(const char *text);
  /** opens a file from the recent files menu */
  void slotFileOpenRecent(int id_);

//  void doSM();

private:
  /** the recent file menu containing the last five opened files */
  QPopupMenu *recent_files_menu;
  /** contains the recently used filenames */
  QStrList recent_files;
  QString lastPixName;
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
  /** opts_menu contains all items of the menubar entry "Optins" */
  QPopupMenu *opts_menu;
  /** edit_menu contains all items of the menubar entry "Edit" */
  QPopupMenu *edit_menu;
  QPopupMenu *learn_menu;
  /** view_menu contains all items of the menubar entry "View" */
//  QPopupMenu *view_menu;
  /** voc_menu contains all items of the menubar entry "Vocabulary" */
  QPopupMenu *voc_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  kvoctrainView *view;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  kvoctrainDoc *doc;
  /** flag if toolbar is visible or not. Used for kconfig and checking the
    * view-menu entry view toolbar. bViewStatusbar does the same for the
    * statusbar.
    */
  bool bViewToolbar;
  bool bViewStatusbar;
  /** used for KConfig to store and restore menubar position. Same with
    * tool_bar_pos. If more menubars or toolbars are created, you should add
    * positions as well and implement them in saveOptions() and readOptions().
    */

  KMenuBar::menuPosition menu_bar_pos;
  KToolBar::BarPosition  tool_bar_pos;

  friend class kvoctrainView;

  vector<QueryEntryRef> random_expr1, random_expr2;
  QuerySelection queryList;

  vector<QString>  used_Menus;
  QTimer          *qtimer;
  QTimer          *btimer;
  int              maxqueryTime;
  int              backupTime;
  bool             smartAppend;
  bool             querymode;
  bool             querying;
  bool             swap_querydir;
  bool             expire;
  bool             block;
  QString          def_lang;
  QString          separator;
  QPopupMenu*      file_open_popup;
  QPopupMenu      *header_m;
  int              act_query_col;
  QString          act_query_trans;
  QString          act_query_org;
  LangSet          langset;
  int              searchpos;
  QString          searchstr;
#ifdef EA_KDE2x
  KLineEdit       *searchLine;
#else
  KLined          *searchLine;
#endif
  QComboBox       *lessons;
  int              act_lesson;
  QStrList         paste_order;
  QFont            tablefont;
  QueryManager     querymanager;
  bool             controlActive;
  bool             shiftActive;
  bool             altActive;
  GradeCols        gradecols;
  ProgressDlg     *pdlg;
  QProgressBar    *pbar;
  QLabel          *vslide_label;
  int              tagCount;
  int              tagLastRow,
                   tagLastCol;
  QLabel          *pron_label;
  QLabel          *rem_label;
  QLabel          *type_label;
  QueryDlgBase    *queryDlg;
  kvoctrainView::Resizer header_resizer;
  int              queryTimeout;
  int              query_cycle;
  int              query_num;
  int              query_startnum;
  vector<PreSetting>  presettings;
  CAboutDialog      *mAboutDialog;
  QueryType        queryType;
};
 
#endif // KVOCTRAIN_H

