/***************************************************************************
             TenseEntryPage.cpp  -  tenses of irreg. verbs dialog page
                             -------------------                                         
    begin                : Sat Nov 27 20:20:34 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "TenseEntryPage.h"

#define Inherited TenseEntryPageData

#include <qkeycode.h>

#include <kapp.h>
#include "eadebug.h"

TenseEntryPage::TenseEntryPage
(
        QDialog           *dlgbook,
        bool               multi_sel,
        const Conjugation &con_prefix,
        const Conjugation &conjug,
        QWidget           *parent = NULL,
        const char        *name = NULL
)                       
	:
	Inherited( parent, name ),
        multi_mode(multi_sel)
{
   prefix = con_prefix;
   conjugations = conjug;
   selection = "";
   if (multi_mode)
     tensebox->setEnabled(false);
   else  {
     for (int i = 0; i <  Conjugation::numNames(); i++)
       tensebox->insertItem (Conjugation::getName(i) );
   }

   slotTenseSelected(0);
/*
   // FIXME: fill labels with prefixes ?

   label_first_plural->setText (con_prefix.pers1Plural (CONJ_PREFIX));
   label_first_singular->setText (con_prefix.pers1Singular (CONJ_PREFIX));
   label_second_singular->setText (con_prefix.pers2Singular (CONJ_PREFIX));
   label_second_plural->setText (con_prefix.pers2Plural (CONJ_PREFIX));
   label_thirdF_plural->setText (con_prefix.pers3FemalePlural (CONJ_PREFIX));
   label_thirdF_singular->setText (con_prefix.pers3FemaleSingular (CONJ_PREFIX));
   label_thirdM_singular->setText (con_prefix.pers3MaleSingular (CONJ_PREFIX));
   label_thirdN_singular->setText (con_prefix.pers3NaturalSingular (CONJ_PREFIX));
   label_thirdN_plural->setText (con_prefix.pers3NaturalPlural (CONJ_PREFIX));
   label_thirdM_plural->setText (con_prefix.pers3MalePlural (CONJ_PREFIX));
*/
   b_next->setEnabled(false); // next button

   tenselabel->setBuddy(tensebox);

   pers1_label->setBuddy(first_singular);
   pers2_label->setBuddy(second_singular);
   pers3_label->setBuddy(thirdF_singular);

   female_label->setBuddy(thirdF_singular);
   male_label->setBuddy(thirdM_singular);
   natural_label->setBuddy(thirdN_singular);
}


TenseEntryPage::~TenseEntryPage()
{
}


void TenseEntryPage::initFocus() const
{
  first_plural->setFocus();
}


void TenseEntryPage::firstPluralChanged(EA_QTSTR s)
{
   conjugations.setPers1Plural (selection, s);
}


void TenseEntryPage::firstSingularChanged(EA_QTSTR s)
{
   conjugations.setPers1Singular (selection, s);
}


void TenseEntryPage::secondSingularChanged(EA_QTSTR s)
{
   conjugations.setPers2Singular (selection, s);
}


void TenseEntryPage::secondPluralChanged(EA_QTSTR s)
{
   conjugations.setPers1Plural (selection, s);
}


void TenseEntryPage::thirdFPluralChanged(EA_QTSTR s)
{
   conjugations.setPers3FemalePlural (selection, s);
}


void TenseEntryPage::thirdFSingularChanged(EA_QTSTR s)
{
   conjugations.setPers3FemaleSingular (selection, s);
}


void TenseEntryPage::thirdMSingularChanged(EA_QTSTR s)
{
   conjugations.setPers3MaleSingular (selection, s);
}


void TenseEntryPage::thirdNSingularChanged(EA_QTSTR s)
{
   conjugations.setPers3NaturalSingular(selection, s);
}


void TenseEntryPage::thirdNPluralChanged(EA_QTSTR s)
{
   conjugations.setPers3NaturalPlural (selection, s);
}


void TenseEntryPage::thirdMPluralChanged(EA_QTSTR s)
{
   conjugations.setPers3MalePlural (selection, s);
}


void TenseEntryPage::slotTenseSelected(int sel)
{
   if (multi_mode) {
     third_s_common->setEnabled(false);
     third_p_common->setEnabled(false);
     first_plural->setEnabled(false);
     first_singular->setEnabled(false);
     second_singular->setEnabled(false);
     second_plural->setEnabled(false);
     thirdF_plural->setEnabled(false);
     thirdF_singular->setEnabled(false);
     thirdM_singular->setEnabled(false);
     thirdN_singular->setEnabled(false);
     thirdN_plural->setEnabled(false);
     thirdM_plural->setEnabled(false);
   }
   else {
     selection = Conjugation::getAbbrev(sel);
     KASSERT(!selection.isEmpty(), KDEBUG_ERROR, 0, (QString)"slotTenseSelected: empty type");
     first_plural->setText (conjugations.pers1Plural (selection ));
     first_singular->setText (conjugations.pers1Singular (selection ));
     second_singular->setText (conjugations.pers2Singular (selection ));
     second_plural->setText (conjugations.pers2Plural (selection ));
     thirdF_plural->setText (conjugations.pers3FemalePlural (selection ));
     thirdF_singular->setText (conjugations.pers3FemaleSingular (selection ));
     thirdM_singular->setText (conjugations.pers3MaleSingular (selection ));
     thirdN_singular->setText (conjugations.pers3NaturalSingular (selection ));
     thirdN_plural->setText (conjugations.pers3NaturalPlural (selection)); 
     thirdM_plural->setText (conjugations.pers3MalePlural (selection));
  
     bool common = conjugations.pers3SingularCommon(selection);
     third_s_common->setChecked(common);
     thirdM_singular->setEnabled(!common);
     thirdN_singular->setEnabled(!common);
  
     common = conjugations.pers3PluralCommon(selection);
     third_p_common->setChecked(common);
     thirdN_plural->setEnabled(!common);
     thirdM_plural->setEnabled(!common);
   }
}


void TenseEntryPage::slotThirdSCommonToggled(bool common)
{
  if (multi_mode) {
    conjugations.setPers3SingularCommon(selection, common);
    thirdM_singular->setEnabled(!common);
    thirdN_singular->setEnabled(!common);
  }
}


void TenseEntryPage::slotThirdPCommonToggled(bool common)
{
  if (multi_mode) {
    conjugations.setPers3PluralCommon(selection, common);
    thirdN_plural->setEnabled(!common);
    thirdM_plural->setEnabled(!common);
  }
}


void TenseEntryPage::slotNextConj()
{

}


Conjugation TenseEntryPage::getConjugation()
{
  conjugations.cleanUp();
  return conjugations;
}


void TenseEntryPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
