/***************************************************************************
                  CommonEntryPage.h  -- edit common properties
                             -------------------                                         
    begin                : Mon Jun 28 21:02:16 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CommonEntryPage_included
#define CommonEntryPage_included

#include "CommonEntryPageData.h"
#include "QueryManager.h"

class CommonEntryPage : public CommonEntryPageData
{
    Q_OBJECT

public:

    CommonEntryPage
    (
        QDialog    *dlgbook,
        kvoctrainDoc *doc,
        bool        multi_sel,
        QString     expr,
        int         less,
        QComboBox  *lessBox,
        QString     lang,
        QString     remark,
        QString     type,
        QString     pronunce,
        QString     example,
        const char *label,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    bool    lessonDirty  () const { return lesson_dirty; }
    bool    typeDirty    () const { return type_dirty; }

    int     getLesson  () const { return lesson; }
    QString getType    () const { return type; }
    QString getExpr    () const { return expression; }
    QString getRemark  () const { return remark; }
    QString getPronunce() const { return pronunce; }
    QString getExample () const { return example; }

    virtual ~CommonEntryPage();


signals:
    void typeSelected(const QString &);

protected:
    void keyPressEvent( QKeyEvent * );
    void setTypeBox(const QString &act_type);
    void setLessonBox(QComboBox *lessbox, int lesson);

protected slots:
    virtual void initFocus() const;
    virtual void slotLessonSelected(int);
    virtual void slotRemarkSelected (EA_QTSTR);
    virtual void slotExprSelected(EA_QTSTR);
    virtual void slotTypeSelected(int);
    virtual void slotSubTypeSelected(int);
    virtual void slotPronunceSelected (EA_QTSTR);
    virtual void slotExampSelected(EA_QTSTR);
    virtual void invokeLessDlg();
    virtual void invokeTypeDlg();
    virtual void invokePronDlg();

protected:
    QString   pronunce;
    QString   example;
    QString   remark;
    QString   expression;
    int       lesson;
    QString   type;
    QDialog  *dlgbook;
    bool      lesson_dirty;
    bool      type_dirty;
    kvoctrainDoc *doc;

    vector<TypeRelation> all_maintypes;
    vector<TypeRelation> all_types;
    vector<QString> current_subtypes;
};
#endif // CommonEntryPage_included
