/***************************************************************************
        AdjEntryPage.cpp  -  dialog page for adjectives (comparison)
                          -------------------
    begin                : Sat Dec 4 18:09:29 1999
                                           
    copyright            : (C) 1999,2000 by Ewald Arnold                         
    email                : ewald@ewald-arnold.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "AdjEntryPage.h"

#define Inherited AdjEntryPageData

#include <qkeycode.h>

#include <kapp.h>

AdjEntryPage::AdjEntryPage
(
        QDialog           *dlgbook,
        bool               multi_sel,
        const Comparison  &comp,
        QWidget           *parent = NULL,
        const char        *name = NULL
)
	:
	Inherited( parent, name )
{
   comparisons = comp;

   lev1Label->setBuddy(lev1Field);
   lev2Label->setBuddy(lev2Field);
   lev3Label->setBuddy(lev3Field);

   if (multi_sel) {
     lev1Field->setEnabled(false);
     lev2Field->setEnabled(false);
     lev3Field->setEnabled(false);
   }
   else {
     lev1Field->setText (comp.l1());
     lev2Field->setText (comp.l2());
     lev3Field->setText (comp.l3());
   }
}


void AdjEntryPage::initFocus() const
{
  lev1Field->setFocus();
}


void AdjEntryPage::returnPressed()
{
   emit accept();
}


void AdjEntryPage::lev1Changed(EA_QTSTR s)
{
    comparisons.setL1 (s);
}


void AdjEntryPage::lev2Changed(EA_QTSTR s)
{
    comparisons.setL2 (s);
}


void AdjEntryPage::lev3Changed(EA_QTSTR s)
{
    comparisons.setL3 (s);
}


AdjEntryPage::~AdjEntryPage()
{
}


void AdjEntryPage::keyPressEvent( QKeyEvent *e )
{
   if (e->state() & AltButton & ControlButton & ShiftButton == 0) {
     if (  e->key() == Key_Escape )
       emit reject();
     else if (  e->key() == Key_Enter
              ||e->key() == Key_Return)
       emit accept();
     else
       e->ignore();
   }
   else
     e->ignore();
}
