/***************************************************************************
                          voklist.h  -  description
                             -------------------
    begin                : Fri Sep 24 1999
    copyright            : (C) 1999 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef VVOKLIST_H
#define VVOKLIST_H

#include <qlistview.h>
#include <qclipboard.h>
#include <qapplication.h>

#include "../vvokabellist.h"
#include "listedit.h"

/**
  *@author Friedrich W. H. Kossebau
  */

  
class VVokList;  
  
class VVokItem : public ListEditItem  
{
  public: 
  	VVokItem( QListView * parent, VVokabel *Vok );
  	VVokItem( QListView * parent, QListViewItem * after, VVokabel *Vok );
  	~VVokItem();
  	
    /** returns the text right out of the basic list */
    virtual const char *text( int column ) const;
    /** sets text direct in the basic list */
    virtual void setText( int column, const char *text);
    /** returns a pointer to its vokabel */
    VVokabel * vokabel();
    
  protected:
  	VVokabel *Vokabel;
};


/**implements the view of the list of the vocabulary
  *@author Friedrich W. H. Kossebau
  */

class VVokList : public ListEdit
{
  Q_OBJECT
  
  friend class VVokItem;
  
  public: 
  	VVokList( QWidget *parent=0, const char *name=0 );
  	~VVokList();
	  /** appends new vokabel at the end */
	  virtual void appendVokabel( VVokabel *Vokabel, bool UpdateView = true );
	  /** changes the size of the header to fit in the view
		as standard there should be no horizontal Scrollbar */
	  void adjustHeaderWidth( int Width = -1, int Height = -1 );
	  /** ensures correct headersetting */
//	  void show();
	  /** ensures correct headersetting */
    void resizeEvent ( QResizeEvent * e ); 
    /** returns the first seleted vok */
    VVokabel *currentVok();
    /** returns the first seleted vok */
    VVokabel *firstSelectedVok();
    /** returns the next selected vok */
    VVokabel *nextSelectedVok( bool first = false );
    /**  inserts text in the editfield from the clipboard*/
    void insertText();
    /**  copies text from the editfield*/
    void copyText() { EditField->copy(); }
    /**  cuts text from the editfield*/
    void cutText() { EditField->cut(); }
    /** selects all */
    void selectAll();
    /** deselects all */
    void deselectAll();
    /** inverts Selection */
    void invertSelection();

  private:
    /** */
    VVokItem *SelectedIterator;
    VVokItem *Iterator;
    
	protected: // Protected methods
	  /**  */
	  virtual bool handleEnterPress( const QKeyEvent *k );
	  /**  reimplemented for Clipboard Checking*/
    virtual void focusInEvent( QFocusEvent * Event );
//    virtual void paintEvent ( QPaintEvent * );
 
	signals: // Signals
	  /** is emmited if Enter is pressed at the last line */
	  void enterPressedLastLine();
	  /**  */
	  void clipboardHasData( bool );
};

#endif
