/***************************************************************************
                          listpropedit.h  -  description
                             -------------------
    begin                : Tue Jan 4 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VLISTDIALOG_H
#define VLISTDIALOG_H

#include <qgroupbox.h>
#include <qlineedit.h>
#include <qmultilinedit.h> 
#include <qlabel.h>

#include "vdialog.h"
#include "vlangbox.h"

/**
  *@author Friedrich W. H. Kossebau
  */

class VListDialog : public VDialog  
{
  Q_OBJECT
   
  public: 
  	VListDialog( QWidget *parent=0, const char *name=0 );
  	~VListDialog();
    /** opens the dialog and returns true if anything was modified */
    bool wasModified( const QString &Titel, 
                      const QString &TermTitel, const QString &TranslationTitel, 
                      const QString &TermLanguage, const QString &TranslationLanguage, 
                      const QString &Comment, const QString &KeyWords, const QString &Author );

  protected: 
    /** sets the layout */
    void setLayout();
  
  protected: 
  	// the general block
  	QGroupBox General;
  	QGridLayout GeneralLayout;
  	
  	QLineEdit TitelEdit;
  	QLabel TitelLabel;
  	
  	QLineEdit TermTitelEdit;
  	QLabel TermTitelLabel;
  	
  	QLineEdit TranslationTitelEdit;
  	QLabel TranslationTitelLabel;
  	
  	VLanguageBox TermLanguageBox;
  	VLanguageBox TranslationLanguageBox;
  	
  	// layout of the block additional
  	QGroupBox Additional;
  	QGridLayout AdditionalLayout;
  	
  	QMultiLineEdit CommentEdit;
  	QLabel CommentLabel;

  	QLineEdit KeyWordsEdit;
  	QLabel KeyWordsLabel;
  	
  	QLineEdit AuthorEdit;
  	QLabel AuthorLabel;
  	  
  public:	
    /** returns the titel */
    const QString titel() { return TitelEdit.text(); };
    /** returns the comment */
    const QString comment() { return CommentEdit.text(); };
    /** returns the keywords */
    const QString keyWords() { return KeyWordsEdit.text(); };
    /** returns the term column titel */
    const QString termTitel() { return TermTitelEdit.text(); };
    /** returns the translation column titel */
    const QString translationTitel() { return TranslationTitelEdit.text(); }
    /** returns the term language */
    const QString termLanguage() { return TermLanguageBox.language(); };
    /** returns the translation language */
    const QString translationLanguage() { return TranslationLanguageBox.language(); }
    /** returns the author */
    const QString author() { return AuthorEdit.text(); };
  	
  private: 
    VLanguageList *LanguageList;
};

#endif
