/***************************************************************************
                          vstring.cpp  -  description
                             -------------------
    {                : Tue Feb 15 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


//TODO: think about an entry in the languages for possible letters and marks
//      which are used to find the words etc.
 
 
#include <iostream.h>
#include "vstring.h"

VString::VString() : QString()
{
  Letters = 0;
}
	
VString::VString( const QString &QS ) : QString( QS )
{
  Letters = 0;
}

VString::VString( QRegExp *RegExp ) : QString()
{
  Letters = RegExp;
}


VString::~VString()
{
}

/** Assigns a deep copy of \a str, interpretted a classic C string to
    this string and returns a reference to this string.

    If \a str is 0 a null string is created.

    \sa isNull()*/
VString &VString::operator=( const char *str )
{
  QString::operator=( str );
  return *this;
}

/** removes blanks at the end and/or the beginning *
void VString::deblank( char where )

CONST Hinten = 1;       {3: Vorne und Hinten}
      Vorne  = 2;

VAR k : byte absolute kette;
    e : byte;

{

 IF Welche AND Hinten = Hinten THEN
    WHILE (kette[k] = ' ') AND (k > 0) DO dec (k);

 IF Welche AND Vorne = Vorne THEN
    {
     e := 0;
     WHILE (kette[e+1] = ' ') AND (e < k) DO inc (e);
     delete (kette,1,e);
    }
} */


/** removes part that is included by brackets of type bracket */
VString &VString::delInBrackets( VString::BracketTyp Bracket, int Pos = 0, 
                                 bool All = false, bool StripOneWhite = true )
{
  int End = 0;
Start:  
  int Length = length() - 1;
 
  // well, Pos should be somewhere in the text
  if( ( Pos > Length ) || ( Pos < 0 )  ) return *this;
 
Schleife1:
//cout << "Pos: " << Pos << ", at( Pos ): " << at( Pos ) <<'\n';
  // search the opening bracket
  if( at( Pos ) != OpenBracket[Bracket] )
  {
    if( at( Pos ) == CloseBracket[Bracket] )
      goto Ende;
    if( Pos >= Length )
      goto Ende;
    else
    {
      Pos++;
      goto Schleife1;
    }
  }
  
  if( Pos == Length )
    // opening bracket is at the end, no removing
    goto Ende;
  else
  {
    // start at next character
    End = Pos + 1;
 
Schleife2:
    // search the closing bracket
    if( at( End ) != CloseBracket[Bracket] )
    {
      if( End < Length )
      {
        // check if there are inner brackets
        if( at( End ) == OpenBracket[Bracket] )
        {
          delInBrackets( Bracket, End );
          Length = length() - 1;
        }
        else
          End++;
        goto Schleife2;
      }
      else
         End = Length;
    }
  }

  // remove one whitechar if possible
  if( StripOneWhite )
  {
    if( (Pos > 0) && (at(Pos-1) == ' ') )
      Pos--;
    else  if( (End < Length) && (at(End+1) == ' ') )
      End++;
  }
  
  // finally cut the found region
  remove( Pos, End-Pos+1 );
  
  if( All ) 
    goto Start;
    
Ende:
  return *this;
}



/** returns true if Letter is in the assigned Letters
    or if there are no Letters assigned is in a..z or A..Z */
bool VString::isLetter( int Pos )
{
  // check if inside string
  if( ( Pos < 0 ) || ( Pos >= (int)length() ) ) return false;
  
  char Letter = at(Pos);
  
  if( Letters )
  {
    return( Letters->match( &Letter ) != -1 );
  }
  else
  {
    return ( ( 'a' <= Letter ) && ( 'z' >= Letter ) ) ||
           ( ( 'A' <= Letter ) && ( 'Z' >= Letter ) );
  }
}



/** searches next left wordbegin from pos, returns pos of first letter
    or -1 if nothing found or outside of string */
int VString::findLeftWord( int Pos )
{
  int Length = length()-1;
 
  if( (Pos > Length) || (Pos < 0) ) return -1; // is outside string
 
  //search word end
  while( (Pos > -1) && !isLetter( Pos ) )
    Pos--;
//cout << "Wordend: " << Pos;
  //word end found?
  if( Pos > -1 )
  {
    //search word begin    
    while( (Pos > -1) && isLetter( Pos ) )
      Pos--;
   
    Pos++; // there will always be one step to much
  }
  
  return Pos;
}



/** searches next word from pos, returns pos of first letter
    or -1 if nothing found or outside of string */
int VString::findRightWord( int Pos = 0 )
{
  int Length = length()-1;
 
  if( (Pos > Length) || (Pos < 0) ) return -1; // is outside string
 
  // find next letter
  while( ( Pos <= Length) && !isLetter( Pos ) )
     Pos++;
 
  // none found?
  if( Pos > Length )
    Pos = -1;
 
  return Pos;
} 


/** searches next word from pos, returns pos of first letter
    or -1 if nothing found or outside of string */
int VString::findWordBegin( int Pos = 0 )
{
  int Length = length()-1;
 
  if( (Pos > Length) || (Pos < 0) ) return -1; // is outside string
 
  // find next letter
  while( ( Pos <= Length) && !isLetter( Pos ) )
     Pos++;
 
  // none found?
  if( Pos > Length )
    Pos = -1;
 
  return Pos;
}



/** searches word end from pos, returns pos of last letter
    or -1 if nothing found or outside of string */
int VString::findWordEnd( int Pos = 0 )
{
  int Length = length()-1; // -1 for better operation 
 
  if( (Pos > Length) || (Pos < 0) ) return -1; // is outside string
 
  // search next non-letter 
  while( isLetter( Pos ) && ( Pos <= Length ) )
    Pos++;
  
  return Pos-1; // as it will stop 1 after the last letter
}
