/***************************************************************************
                          vabfrage.cpp  -  description
                             -------------------
    begin                : Tue Jan 18 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "vabfrage.h"
#include "../File/vlangfile.h"
#include <iostream.h>

VAbfrage::VAbfrage(QWidget *parent, const char *name) 
  : QFrame(parent,name),
	  Layout( this, 6, 1, 10, 0 ),
    GivenText( this, "GivenText" ),
    GivenColumn( &GivenText, i18n("Given"), this, "GivenColumn" ),
    AskingLine( this, "AskingLine" ),
    AskedColumn( &AskingLine, " ", this, "AskedColumn" ),
    LastTry( this, "LastTry" )
{
  setLayout();
  
  // What do when...
  connect( &AskingLine, SIGNAL( returnPressed() ), SLOT( finish() ) );
}


VAbfrage::~VAbfrage(){
}

/** sets the layout */
void VAbfrage::setLayout()
{
  setFrameStyle( Panel | Plain );
  setLineWidth( 1 );

  // layout 
  Layout.addWidget( &GivenColumn, 0, 0, AlignLeft | AlignBottom );
  Layout.addWidget( &GivenText, 1, 0 );
  Layout.addRowSpacing( 2, 10 );
  Layout.addWidget( &AskedColumn, 3, 0, AlignLeft );
  Layout.addWidget( &AskingLine, 4, 0 );
  Layout.addWidget( &LastTry, 5, 0, AlignLeft | AlignTop );
  
  Layout.setRowStretch( 0, 1 );
  Layout.setRowStretch( 5, 1 );
  
	// Given is:
  GivenText.setFixedHeight( GivenText.sizeHint().height() );
  GivenText.setMinimumWidth( GivenText.sizeHint().width() );
  GivenText.setFocusPolicy( QWidget::NoFocus );
  GivenText.setCursor( arrowCursor );
  GivenColumn.setFixedSize( GivenColumn.sizeHint() );
  
  // Asked is:
  AskedColumn.setFixedHeight( AskedColumn.sizeHint().height() );
  AskedColumn.setMinimumWidth( AskedColumn.sizeHint().width() );
  AskingLine.setFixedHeight( AskingLine.sizeHint().height() );
  AskingLine.setMinimumWidth( AskingLine.sizeHint().width() );
  AskingLine.setFocus();
  
  // Last try was:    
  LastTry.setText(" ");
  LastTry.setMinimumSize( LastTry.sizeHint() );
  
  // Layout is finally prepared
  Layout.activate();
}


/** checks if the input is correct */
void VAbfrage::finish()
{
  if( OnlyConfirmation )
    emit confirmed();
  else
    emit inputFinished( AskingLine.text() );
}

/** sets the output */
void VAbfrage::setInputLabel()
{
  if( OnlyConfirmation ) AskedColumn.setText( i18n("Right is") );
  else AskedColumn.setText( i18n("Asked") );
}

/** sets the output */
void VAbfrage::askAgain( QString Answer = 0, bool ShowLastInput = false, bool LetOnlyConfirm = false )
{
  if( ShowLastInput ) LastTry.setText( AskingLine.text() );
  else LastTry.setText( "" );

  if( Answer ) AskingLine.setText( Answer );
  
  AskingLine.setFocus();
  OnlyConfirmation = LetOnlyConfirm;
  setInputLabel();
}


/** sets the output */
void VAbfrage::ask( QString GivenTerm )
{
  GivenText.setText( GivenTerm );
  LastTry.setText( "" );
  AskingLine.setText( "" );
  
  AskingLine.setFocus();
  OnlyConfirmation = false;
  setInputLabel();
}



/** */
QSize VAbfrage::sizeHint() const
{
  int Height = 3*AskedColumn.sizeHint().height() + 2*AskingLine.sizeHint().height() + 12;
  int Width  = AskingLine.sizeHint().width();
  
  QSize Size( Width, Height );
  
  return Size;
}


void VAbfrage::setLanguage( int Line, const char *Language )
{
  if( Language && (Language != "") )
  {
    VLanguageFile *LanguageFile = new VLanguageFile( Language, true );
    if( Line == 0 )
      GivenText.setFont( LanguageFile->font() );
    else
      AskingLine.setFont( LanguageFile->font() );
    delete LanguageFile;
  }
}
