/***************************************************************************
                          cchartwidget.h  -  description                              
                             -------------------                                         
    begin                : Thu Sep 2 1999                                           
    copyright            : (C) 1999 by Joachim Ansorg
    email                : Jockel123@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CCHARTWIDGET_H
#define CCHARTWIDGET_H

#include <qwidget.h>
#include <qpainter.h>
#include <qstrlist.h>
#include <qlist.h>

//some defines to customize the view of the chartwidget
#define BAR_WIDTH	20
#define BAR_SPACE	5
#define AXES_SPACE 15

//the number of books in the bibles
#define	BOOKS 66

/**
	* This widgets paints a bar chart.
	* It uses very simple functions
	*
  * @author Joachim Ansorg
	*/
class CChartWidget : public QWidget
{
   Q_OBJECT

public:
	/** The constructor of this widget
		*/
	CChartWidget(QWidget *parent=0, const char *name=0);
	
	/** The destructor of this class
		*/
	~CChartWidget();

  /** Hide a bar to the bar list and repaints.
  	*/
  virtual void addBar(int value, QString text);

  /** Sets the maximum heitght of a bar in this analysis.
  	*/
  virtual void setMaxCount( int value );

protected:
  /** Paints a bar.
  	*
  	* @param x	The graph position on the X axe
  	* @param y	The graph position on the y axe
 		* @param value	The height of the graph
  	*/
  virtual void paintBar(int x, int y, int value);

  /** Implmentation of the paint event.
		* Updates the bars.
		*/
  virtual void paintEvent(QPaintEvent *event);

  /** Paints the axes ogf the graph.
  	*/
  virtual void paintAxes();

  /** Paints the texts at the position x,y
  	* This function has to be optimized for best perfomance!
  	*/
  virtual void paintText();
  /**The resizeevent implementation. We recalc the unit because the window height changed.
  	*/
  void resizeEvent( QResizeEvent *event );

  /** This is the painter we use in this widget to paint the bars.
  	*/
  QPainter 		painter;

  /** Contains the labels of each bar
  	*/
  QStrList		textList;

  /**
  	*/
  QList<int>	valueList;
	
  /** Contains the number of used bars.
  	*/
	int				  barCount;

  /** maxcount contains the most found entries of a book. Set in function setMaxCout
	 	*
  	* @see #setMaxCount
  	*/
  int					maxCount;

  /** The variable unit represents the unit to calculate the bar height.
  	*/
  float				unit;
};

#endif