/* 
  Copyright (c) 1998 Further Consulting
  All rights reserved.
 
  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. All advertising materials mentioning features or use of this software
     must display the following acknowledgement:
       This product includes software developed by A & A Custom Software 
       and its contributors.
  4. Neither the name of Further Consulting nor the names of its 
     contributors may be used to endorse or promote products derived from this 
     software without specific prior written permission.
 
  THIS SOFTWARE IS PROVIDED BY FURTHER CONSULTING AND CONTRIBUTORS ``AS IS''
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL FURTHER CONSULTING OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
 
 $Header: /home/jonny/src/cvs/khylafax/khylafax/prefs.h,v 1.1.1.1 1999/02/25 15:28:10 jonny Exp $

*/
#ifndef _FAX_PREFS_WIDGET_H
#define _FAX_PREFS_WIDGET_H

#include <kfm.h>
#include <kapp.h>
#include <qtabdlg.h>
#include <kspinbox.h>
#include <qchkbox.h>
#include <qradiobt.h>

class KHylaFaxPrefs : public QTabDialog {
  Q_OBJECT

 public:
  KHylaFaxPrefs(KConfig *conf);
  ~KHylaFaxPrefs();

 public slots:
    void savePrefs();
 
 private:
 
 QLineEdit *name;
 QLineEdit *company;
 QLineEdit *location;
 QLineEdit *voice;
 QLineEdit *faxNum;
 QLineEdit *host;
 KNumericSpinBox *retry;
 QCheckBox *coverPage;
 QRadioButton *dpi98;
 QRadioButton *dpi196;
 QCheckBox *notifyRetry;
 QCheckBox *notifyDone;
 KConfig *config;
 QLineEdit *user;
 QCheckBox *autocheck;
 QCheckBox *dock;
 KNumericSpinBox *autocheckinterval;
};

#endif _FAX_PREFS_WIDGET_H

/*

$Log: prefs.h,v $
Revision 1.1.1.1  1999/02/25 15:28:10  jonny


Revision 0.2  1998/07/21 15:04:58  jlublin
Added initial support for calling the sendfax program of HylaFax.
It works, but it is ugly and uses system instead of forking.
It will not catch any errors yet.

Needs a lot of work.

Revision 0.1.1.1  1998/06/11 17:52:41  jlublin
Initial Rev

Revision 0.2  1998/06/11 17:47:37  jlublin
Added support for saving and restoring preferences

Revision 0.1.1.1  1998/06/03 00:06:48  jlublin
Initial Rev


*/









