/***************************************************************************
    kuninstalllistview.h  -  description                              
    -------------------                                         
    begin                : Tue Mar 16 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KUNINSTALLLISTVIEW_H
#define KUNINSTALLLISTVIEW_H

#include "kuninstalllistitem.h"

/**
  * This class provides the list view for the Application View. It is derived from the QListView
  * and overloads some functions for own representations.
  * @author Geri House
  * @see KUninstallerView
  */

class KUninstallListView : public QListView  {

 Q_OBJECT

public: 
  	/** Constructor */
	KUninstallListView( QWidget * parent = 0, const char * name = 0);
  	/** Destructor */
	~KUninstallListView();
  	/** overloaded for mouse press events*/
    void mousePressEvent ( QMouseEvent * );
  	/** overloaded for mouse double click events*/
    void mouseDoubleClickEvent(QMouseEvent *);
  	/** Returns the last size of the items*/
    float getLastSize() { return lastSize;}
  	/** Returns the last number of the items*/
    int getLastNumber() { return lastNumber;}

signals:
  	/** Signal changeChecked will be emited if the Item changes the state*/
    void changeChecked( KUninstallListItem * );
  	/** signal for updating the number of items label*/
    void emitUpdateNumLabel(int);
  	/** signal for updating the size of items label*/
    void emitUpdateSizeLabel(float);

private slots:
  	void checkApp();
  	void uncheckApp();
  	void uncheckall();
  	void checkall();
  	void checkOne();
  	void expandOrCollapse();
  	
private:
	void checkItemAndChilds(KUninstallListItem *, bool );

    float lastSize;
    int lastNumber;
};

#endif










































































