/***************************************************************************
    kuninstalllistitem.h  -  Header file of class KUninstallListItem
    ------------------------------------------------------------------------
    begin                : Wed Mar 17 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KUNINSTALLLISTITEM_H
#define KUNINSTALLLISTITEM_H

#include <qlistview.h>
#include <qfileinfo.h>
#include <qpixmap.h>
#include <qdir.h>
#include <qlist.h>

/**
  * This class provides the list view items for the ListView. It is derived from the QCheckListItem
  * and overloads sone functions and add some own stuff. Every KUninstallListItem has its own FileInfo.
  * @author Geri House
  * @see KUninstallListView
  */


class KUninstallListItem : public QCheckListItem  {
public: 
  	/** Constructor */
	KUninstallListItem(QFileInfo , QCheckListItem * , const char * , QCheckListItem::Type = Controller);
  	/** Constructor */
	KUninstallListItem(QFileInfo , QListView * , const char * , QCheckListItem::Type = Controller );
  	/** Constructor */
	KUninstallListItem(QFileInfo , QListViewItem * , const char * , const QPixmap & );
  	/** Constructor */
	KUninstallListItem(QFileInfo , QListView * , const char * , const QPixmap &);
  	/** Destructor */
	~KUninstallListItem();
  	/** Returns the FileInfo of the Item
  	 * @return FileInfo of representing File
  	 */
	QFileInfo info() { return finfo;}
  	/** Checks all Childs Items*/
	void checkAllChilds(bool);
  	/** Returns the text of the given column */
    const char * text( int column ) const;
  	/** Returns the name of item */
    const char * text() const;
  	/** Returns the Size and Number of enabled items
  	 * @return size of items
  	 * @param int& number of items
  	 */
	float getSizeAndNumber(int &);
	
public slots:	
  	/** Shows all Childs Items*/
  	void showChildItems();

protected:	
	const QPixmap * pixmap ( int column ) const;
private:
	QFileInfo finfo;	
};

typedef Q_DECLARE(QListM,KUninstallListItem)    KUnInstallItemList;

#endif
































