/***************************************************************************
    kuninstalleroption.cpp  -  source file of class KUninstallerOption
    ------------------------------------------------------------------------
    begin                : Mon Mar 22 1999                                           
    copyright            : (C) 1999 by Geri House                         
    email                : ge_ha@yahoo.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <qbttngrp.h>
#include <qfiledialog.h>


#include <kapp.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include "kuninstalleroption.h"

KUninstallerOption::KUninstallerOption(QWidget * parent, const char * name, bool modal)
:QDialog(parent,name,modal){
  	KConfig *config = kapp->getConfig();
  	config->setGroup("OPTIONS");
	
	QLabel* Label_2;
	Label_2 = new QLabel( this, "Label_2" );
	Label_2->setGeometry( 110, 20, 300, 30 );
	{
		QFont font( "helvetica", 18, 75, 0 );
		Label_2->setFont( font );
	}
	Label_2->setText( i18n("Options for the Application") );
	Label_2->setAlignment( 289 );

	QButtonGroup* buttonGroup;
	buttonGroup = new QButtonGroup( this, "buttonGroup" );
	buttonGroup->setGeometry( 30, 90, 430, 130 );

	backupCheckBtn = new QCheckBox( this, "backupCheckBtn" );
	backupCheckBtn->setGeometry( 30, 50, 350, 30 );
	backupCheckBtn->setText( i18n("Make a Backup before Uninstalling") );
  	backupCheckBtn->setChecked(config->readBoolEntry("Backup", true));

	defaultRadioBtn = new QRadioButton( this, "defaultRadioBtn" );
	defaultRadioBtn->setGeometry( 40, 100, 410, 26 );
	QString str = kapp->localkdedir();
	str+="/share/apps/kuninstaller";
	str.prepend(i18n("Default: "));
	defaultRadioBtn->setText( str );
	defaultRadioBtn->setChecked(config->readBoolEntry("DefaultPath", true));
    defaultRadioBtn->setEnabled(FALSE);

	ownRadioBtn = new QRadioButton( this, "ownRadioBtn" );
	ownRadioBtn->setGeometry( 40, 140, 70, 26 );
	ownRadioBtn->setText( i18n("Other: ") );
	
	pathLineEdit = new QLineEdit( this, "pathLineEdit" );
	pathLineEdit->setGeometry( 110, 140, 290, 26 );
    pathLineEdit->setEnabled(FALSE);

	if (config->readBoolEntry("DefaultPath", true)==false) {
		ownRadioBtn->setChecked(TRUE);
		pathLineEdit->setText(config->readEntry("Path",""));
	}
    ownRadioBtn->setEnabled(FALSE);

	dirBtn = new QPushButton( this, "dirBtn" );
    dirBtn->setPixmap(kapp->getIconLoader()->loadIcon("mini/folder_open.xpm"));
	dirBtn->setGeometry( 410, 140, 26, 26 );
    dirBtn->setEnabled(FALSE);

    label2 = new QLabel(this,"Label2");
    label2->setText(i18n("Max. Number of Backups:"));
	label2->setGeometry( 40, 180, 160, 26 );

    numberBackups = new  QSpinBox(1, 20, 1, this, "numberBackups");
    numberBackups->setWrapping(TRUE);
	numberBackups->setGeometry( 205, 180, 40, 26 );
    numberBackups->setValue(config->readNumEntry("NumberBackups",1));

	addSearchBtn = new QCheckBox( this, "addSearchBtn" );
	addSearchBtn->setGeometry( 30, 240, 160, 30 );
	addSearchBtn->setText( i18n("Additional Searchpath:") );
  	addSearchBtn->setChecked(config->readBoolEntry("AddSearch", false));
	
	dirSearchBtn = new QPushButton( this, "dirSearchBtn" );
    dirSearchBtn->setPixmap(kapp->getIconLoader()->loadIcon("mini/folder_open.xpm"));
	dirSearchBtn->setGeometry( 430, 240, 26, 26 );
	
	pathSearchEdit = new QLineEdit( this, "pathSearchEdit" );
	pathSearchEdit->setGeometry( 190, 240, 230, 26 );
    if (addSearchBtn->isChecked()==TRUE) {
		pathSearchEdit->setText(config->readEntry("SearchPath",""));
    	pathSearchEdit->setEnabled(TRUE);		
   		dirSearchBtn->setEnabled(TRUE);
	}
	else  {
    	pathSearchEdit->setEnabled(FALSE);
    	dirSearchBtn->setEnabled(FALSE);
    }
	buttonGroup->insert( defaultRadioBtn );
	buttonGroup->insert( ownRadioBtn );
	buttonGroup->insert( dirBtn );
    buttonGroup->setEnabled(FALSE);

	QPushButton* okBtn;
	okBtn = new QPushButton( this, "okBtn" );
	okBtn->setGeometry( 70, 300, 100, 30 );
	okBtn->setText( i18n("OK") );

	QPushButton* cancelBtn;
	cancelBtn = new QPushButton( this, "cancelBtn" );
	cancelBtn->setGeometry( 250, 300, 100, 30 );
	cancelBtn->setText( i18n("Cancel") );

	resize( 470,350 );
	
	connect( cancelBtn, SIGNAL(clicked()),this, SLOT(reject()) );
	connect( okBtn, SIGNAL(clicked()),this, SLOT(closeWithSaving()) );
	connect( dirBtn, SIGNAL(clicked()),this, SLOT(selectDir()) );
	connect( dirSearchBtn, SIGNAL(clicked()),this, SLOT(selectSearchDir()) );
	connect( backupCheckBtn, SIGNAL(clicked()),this, SLOT(updateBtnGroup()) );
	connect( addSearchBtn, SIGNAL(clicked()),this, SLOT(updateAddSearch()) );
	updateBtnGroup();
}

KUninstallerOption::~KUninstallerOption(){
}

void KUninstallerOption::closeWithSaving() {
    if (backupCheckBtn->isChecked()==TRUE &&
        defaultRadioBtn->isChecked()==FALSE &&
        strcmp(pathLineEdit->text(),"")==0) {
		KMsgBox::message(this, i18n("Options error"),
	          i18n("No Path is selected for the BackupDir!"),
	          KMsgBox::EXCLAMATION);
    }
    else if (addSearchBtn->isChecked()==TRUE &&
        strcmp(pathSearchEdit->text(),"")==0) {
		KMsgBox::message(this, i18n("Options error"),
	          i18n("No Path is selected for the Additional SearchDir!"),
	          KMsgBox::EXCLAMATION);
	}
    else {
  		KConfig *config = kapp->getConfig();
  		config->setGroup("OPTIONS");
    	config->writeEntry("Backup",backupCheckBtn->isChecked());
    	config->writeEntry("DefaultPath",defaultRadioBtn->isChecked());
    	config->writeEntry("Path",pathLineEdit->text());
    	QString num(numberBackups->text());
		config->writeEntry("NumberBackups",num.toInt());		
    	config->writeEntry("AddSearch",addSearchBtn->isChecked());
    	config->writeEntry("SearchPath",pathSearchEdit->text());
		accept();
	}
}

void KUninstallerOption::updateAddSearch() {
	if (addSearchBtn->isChecked()==TRUE) {
    	dirSearchBtn->setEnabled(TRUE);
    	pathSearchEdit->setEnabled(TRUE);
	}
	else {
    	dirSearchBtn->setEnabled(FALSE);
    	pathSearchEdit->setEnabled(FALSE);
	}
}

void KUninstallerOption::updateBtnGroup() {
	if (backupCheckBtn->isChecked()==TRUE) {
    	dirBtn->setEnabled(TRUE);
    	pathLineEdit->setEnabled(TRUE);
    	defaultRadioBtn->setEnabled(TRUE);
    	ownRadioBtn->setEnabled(TRUE);	
    	label2->setEnabled(TRUE);
    	numberBackups->setEnabled(TRUE);
	}
	else {
    	dirBtn->setEnabled(FALSE);
    	pathLineEdit->setEnabled(FALSE);
    	defaultRadioBtn->setEnabled(FALSE);
    	ownRadioBtn->setEnabled(FALSE);	
    	label2->setEnabled(FALSE);
    	numberBackups->setEnabled(FALSE);
	}
}

void KUninstallerOption::selectDir(){
    ownRadioBtn->setChecked(TRUE);
    QString str=QFileDialog::getExistingDirectory ();
    if (str.isNull()==FALSE)
    	pathLineEdit->setText(str);
}

void KUninstallerOption::selectSearchDir(){
    QString str=QFileDialog::getExistingDirectory ();
    if (str.isNull()==FALSE)
    	pathSearchEdit->setText(str);
}


























