/************************************************************************
 * kinst - KDE Application Installer - install.h                        *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _INSTALL_H
#define _INSTALL_H

#include "locale.h"
#include "readfile.h"

class tKIFInstall
{
 private:
  QWidget* guiparent;

  tKIFOptions* InstallOptions;
  FILE* InstallCommand_LogFile;
  char Tmp_LogFileName[FILENAME_MAX];
  char* _SourceFileDir;

  int Create_TmpDir();
  int Open_LogFile();
  void Close_LogFile();
  int Read_Line(char* Readed_Line, int length);

 public:

  // Check File/RPM Existance
  // returns :
  // 0 file/RPM doesnt exist
  // 1 file/RPM exists
  int CheckFileExist(char* filename);
  int CheckRPMExist(char* RPM_Name);

  // Install TAR-GZ
  // returns :
  // 0 general failure
  // 1 success
  // 2 source file error
  // 3 write error
  int Install_TGZ(char* TGZ_filename, char* install_to);

  // Install RPM
  // returns :
  // 0 general failure
  // 1 success
  // 2 source file error
  // 3 write error
  int Install_RPM(char* RPM_filename, char* install_to);

  // Install
  // returns :
  // 0 general failure
  // 1 success
  // 2 source file error
  // 3 write error
  // 4 already installed
  int Install(tKIFOptions given_options, char* destfolder);
  int Install(tKIFOptions given_options, char* destfolder, int extnr);

  tKIFInstall(char* SourceFileDir, QWidget* parent);
  ~tKIFInstall();
};

#endif
