/************************************************************************
 * kinst - KDE Application Installer - libraries.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <qdir.h>
#include <qstring.h>

#include "libraries.h"
#include "libverchk.h"

static const int LIBDIRCOUNT = 4;
static const char *LIBDIRS[] = {"/lib", "/usr/local/lib", "/usr/lib",
				"/usr/X11R6/lib"};

tInstSharedLibraries::tInstSharedLibraries()
{
  ActDir = new QDir();
  LibSearchDir = new QDir();
  strcpy(lastmatch, "");
  strcpy(tosearch, "");
}

tInstSharedLibraries::~tInstSharedLibraries()
{
}

QString ExtractLibName(QString s)
{
  long int i;
  long int filenamestart;
  QString returnstring;
  
  returnstring = "";
  
  filenamestart = 0;
  
  for(i = s.length();i >= 0;i--)
    {
      if((s[i] == '/') || (i == 0))
	{
	  if(s[i] == '/') filenamestart = i + 1;
	  else filenamestart = i;
	  i = -1;
	}
    }
  
  for(i = filenamestart;i < (long int) s.length();i++)
    {
      if(s[i] != '.') returnstring += s[i];
      else
	{
	  returnstring.append(0);
	  i = s.length();
	}
    }
  
  return(returnstring);
}

int tInstSharedLibraries::CheckNextLibrary(char* searchname)
{
  QString string;
  char stringptr1[FILENAME_MAX];
  char stringptr2[FILENAME_MAX];
  QString actsearch;
  QFileInfoListIterator LibSearchIt(*LibSearchList);
  bool found, notfound;
  int match;
  int dirno;

  dirno = 0;

  found = false;
  notfound = false;
  match = 0;

  strcpy(searchname, "");

  if(!strcmp(tosearch, "")) return(2); // 2 = All files processed

  while( (LibSearchFi=LibSearchIt.current()) && !found)
    {
      if((qstrcmp(LibSearchFi->fileName().data(), "."))
	 && (qstrcmp(LibSearchFi->fileName().data(), ".."))
	 && (LibSearchFi->isFile()))
	{
	  string = ExtractLibName(LibSearchFi->fileName().data());
	  if(!qstrcmp(string, ExtractLibName(tosearch)))
	    {
	      actsearch = "";
	      actsearch.append(tosearch);
	      found = true;
	      if(LibSearchIt.atLast())
		strcpy(tosearch, "");
	      else
		{
		  ++LibSearchIt;
		  LibSearchFi = LibSearchIt.current();
		  qstrncpy(tosearch, LibSearchFi->fileName().data(),
			   FILENAME_MAX);
		}
	    }
	}
      ++LibSearchIt;
    }

  if(!found) return(3); // err 3 = Search Library Not Found

  found = false;

#ifdef _DEBUG_
  qstrcpy(stringptr1, actsearch);
  printf("libraries:  Searching for %s\n", stringptr1);
#endif

  qstrcpy(searchname, actsearch);

  while((dirno <= LIBDIRCOUNT) && (match != 1))
    {
      ActDir->setPath(LIBDIRS[dirno]);
#ifdef _DEBUG_
      printf("libraries:  In %s\n", LIBDIRS[dirno]);
#endif
      ActList = (QFileInfoList*) ActDir->entryInfoList();
      QFileInfoListIterator ActIt(*ActList);
      while( (ActFi=ActIt.current()) && !notfound && (match !=1))
	{
	  if(ActDir->isReadable()
	     && (qstrcmp(ActFi->fileName().data(), "."))
	     && (qstrcmp(ActFi->fileName().data(), ".."))
	     && (ActFi->isFile()))
	    {
	      string = ExtractLibName(ActFi->fileName().data());
	      if(!qstrcmp(string, ExtractLibName(actsearch)))
		{
		  qstrncpy(stringptr1, ActFi->fileName().data(), FILENAME_MAX);
		  qstrncpy(stringptr2, actsearch, FILENAME_MAX);
		  match = libversioncheck(stringptr1, stringptr2);
#ifdef _DEBUG_
		  printf("libraries:  Found %s  Status: %i\n", stringptr1,
			 match);
#endif
		  if(match != 2) found = true;
		  if(match == 2) match = 0;
		}
	    }
	  if(ActIt.atLast()) notfound = true;
	  ++ActIt;
	}
      notfound = false;
      dirno++;
    }

  if(!found) return(4); // err 4 = library not found

  return(match);
}

int tInstSharedLibraries::RestartLibDir(char* directory)
{
  bool firstfound;

  firstfound = false;

  LibSearchDir->setPath(directory);
  ActDir->setPath(LIBDIRS[0]);

  if(!ActDir->isReadable()) return(0);

  ActList = (QFileInfoList*) ActDir->entryInfoList();
  LibSearchList = (QFileInfoList*) LibSearchDir->entryInfoList();

  ActDir->setFilter(QDir::Files);
  LibSearchDir->setFilter(QDir::Files);

  QFileInfoListIterator LibSearchIt(*LibSearchList);

  strcpy(lastmatch, "");
  while( (LibSearchFi=LibSearchIt.current()) && !firstfound)
    {
      if((qstrcmp(LibSearchFi->fileName().data(), "."))
         && (qstrcmp(LibSearchFi->fileName().data(), ".."))
         && (LibSearchFi->isFile()))
	{
	  qstrncpy(tosearch, LibSearchFi->fileName().data(), FILENAME_MAX);
	  firstfound = true;
	}
      ++LibSearchIt;
    }

  return(1);
}

int tInstSharedLibraries::InstallLibrary(char* filename, char* dir)
{
  int i;
  char cwd[FILENAME_MAX];
  QString s;
  bool success;

  success = false;

#ifdef _DEBUG_
  printf("libraries:  Installing library %s from dir %s\n", filename, dir);
#endif

  for(i = (LIBDIRCOUNT - 1);i >= 0;i--)
    {
      getcwd(cwd, FILENAME_MAX);
      if(chdir(LIBDIRS[i]) == 0)
	{
	  s = "cp -f \"";
	  s += dir;
	  s += "/";
	  s += filename;
	  s += "\" ";
	  s += LIBDIRS[i];
	  system(s);
	  i = 0;
	  success = true;
	}
      chdir(cwd);
    }

  system("ldconfig");
      
  if(success) return(1); else return(0);
}
