/*
   Copyright (c) 2017 Volker Krause <vkrause@kde.org>

   This library is free software; you can redistribute it and/or modify it
   under the terms of the GNU Library General Public License as published by
   the Free Software Foundation; either version 2 of the License, or (at your
   option) any later version.

   This library is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
   License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA.
*/

#ifndef EXTRACTORFILTER_H
#define EXTRACTORFILTER_H

#include <QRegularExpression>
#include <QByteArray>

class QJsonObject;

namespace KItinerary {

/** Determines whether an extractor is applicable to a given email. */
class ExtractorFilter
{
public:
    ExtractorFilter();
    ~ExtractorFilter();

    const char *headerName() const;
    bool matches(const QString &headerData) const;
    bool load(const QJsonObject &obj);

private:
    QByteArray m_headerName;
    QRegularExpression m_exp;
};

}

#endif // EXTRACTORFILTER_H
