#!/usr/bin/python
#
# Test of gtk.Text widget.
#

import sys
import time
from Gtkinter import *
import GtkExtra
				
class Application:		
	def __init__(self, argv):
		self.w_window=GtkWindow()
		self.w_window.set_title("Test application")
		self.w_window.border_width(10)		
		self.w_vbox=GtkVBox()

		self.init_menu()
		self.init_text()
		
		self.w_window.add(self.w_vbox)
		self.w_vbox.show()
		self.w_window.show()		
		
	def mainloop(self):
		mainloop()

	def init_menu(self):
                self.w_menubar=GtkExtra.MenuFactory()
                self.w_menubar.add_entries([
                        ('File/New',        None, self.process_file_new),
                        ('File/Open...','<control>O', self.process_file_open),
                        ('File/Save',       None, self.process_file_save),
                        ('File/Save As...', None, self.process_file_save_as),
                        ('File/Close',      None, self.process_file_close),
                        ('File/<separator>',None, None),
                        ('File/Exit',       None, self.process_file_exit),

                        ('Edit/Cut',   None, self.process_edit_cut),
                        ('Edit/Copy',  None, self.process_edit_copy),
                        ('Edit/Paste', None, self.process_edit_paste),
                ])
                self.w_window.add_accelerator_table(self.w_menubar.accelerator)
                self.w_vbox.pack_start(self.w_menubar, expand=FALSE)
                self.w_menubar.show()

	def init_text(self):		
		self.w_table=GtkTable(2,2,0)
		self.w_table.show()
		
		self.w_text=GtkText()
		self.w_text.set_usize(350,250)
		## Note: editable text is disable in gtk+-971109
		self.w_text.set_editable(0)
		self.w_table.attach(self.w_text,0,1,0,1,xpadding=1,ypadding=1)
		self.w_text.show()

		self.w_hscrollbar=GtkHScrollbar(self.w_text.get_hadjustment())
		self.w_table.attach(self.w_hscrollbar,0,1,1,2,yoptions=FILL)
		self.w_hscrollbar.show()
		
		self.w_vscrollbar=GtkVScrollbar(self.w_text.get_vadjustment())
		self.w_table.attach(self.w_vscrollbar,1,2,0,1,xoptions=FILL)
		self.w_vscrollbar.show()
				
		self.w_vbox.pack_start(self.w_table)
			
	def process_file_new(self, mi):
		print "process_file_new"
		self.w_text.freeze()
		self.w_text.set_point(0)
		self.w_text.forward_delete(self.w_text.get_length())
		self.w_text.insert_defaults("Hello")
		self.w_text.thaw()
		#self.w_text.queueDraw()
		
	def process_file_open(self, mi):
		print "process_file_open"
                fname = GtkExtra.file_open_box(modal=FALSE)
                if fname:
                        try:
                                f=open(fname, "r")
                        except IOError:
                                return
                        self.w_text.freeze()
                        while TRUE:
                                line = f.readline()
                                if line == "":
                                        break
                                self.w_text.insert_defaults(line)
                        self.w_text.thaw()
		
	def process_file_save(self, mi):
		print "process_file_save"
		
	def process_file_save_as(self, mi):
		print "process_file_save_as"
		print GtkExtra.file_save_box(modal=FALSE), "chosen"

	def process_file_save_as_finalize(self, file_name):
		print "process_file_save_as_finalize", file_name
				
	def process_file_close(self, mi):
		print "process_file_close"

	def process_file_exit(self, mi):
		mainquit()
		
	def process_edit_cut(self, mi):
		print "process_edit_cut"
		
	def process_edit_copy(self, mi):
		print "process_edit_copy"
		
	def process_edit_paste(self, mi):
		print "process_edit_paste"
			
			
if __name__ == "__main__":
	use_defaults=0
	for arg in sys.argv:
		if arg == "-d":
			import pdb
			pdb.set_trace()

		if arg == "-n":
			use_defaults=0
			
	if use_defaults == 1:
		gtk.rc_parse("defaults.rc")
	
	app=Application(sys.argv)
	app.mainloop()
	
