<?xml version="1.0" encoding="UTF-8"?>

<!--  simple XSL transformation to create a docbook section  -->

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:dc="http://purl.org/dc/elements/1.1/"
                exclude-result-prefixes="dc">

  <xsl:output method="xml" indent="yes" />

  <xsl:template match="/dc:gimp-authors">
    <xsl:text disable-output-escaping="yes">
      <![CDATA[
    <!DOCTYPE sect1 PUBLIC "-//OASIS//DTD DocBook XML V4.3//EN"
                "http://www.docbook.org/xml/4.3/docbookx.dtd">
    <!-- do not edit this file directly -->
    <!-- it was generated automatically from authors.xml 
         in the root of gimp-help-2 -->
      ]]>
    </xsl:text>
    <sect1 id="gimp-team" lang="en;cs;de;es;fr;it;ko;nl;no">
      <title>
        <phrase lang="en">GIMP User Manual Authors and Contributors</phrase>
        <phrase lang="cs">
          Autoři a přispěvatelé k uživatelské příručce GIMPu
        </phrase>
        <phrase lang="de">
          Autoren und Mitwirkende des GIMP-Benutzerhandbuches
        </phrase>
        <phrase lang="es">
          Autores y contribuyentes al manual de usuario del GIMP
        </phrase>
        <phrase lang="fr">
          Auteurs et contributeurs du Guide de l'utilisateur Gimp
        </phrase>
        <phrase lang="it">
          Autori e collaboratori del manuale utente di GIMP
        </phrase>
        <phrase lang="ko">김프 사용자 설명서 저자 및 기고자</phrase>
        <phrase lang="nl">
          Schrijvers en medewerkers aan de GIMP Handleiding
        </phrase>
        <phrase lang="no">
          Personane bak <acronym>GIMP</acronym>-handboka
        </phrase>
      </title>
    
      <variablelist>
        <varlistentry>
          <term lang="en">Content Writers</term>
          <term lang="cs">Autoři obsahu</term>
          <term lang="de">Autoren und Mitwirkende</term>
          <term lang="es">Escritores del contenido</term>
          <term lang="fr">Rédacteurs du contenu</term>
          <term lang="it">Autori</term>
          <term lang="ko">본문 저자</term>
          <term lang="nl">Schrijvers en vertalers</term>
          <term lang="no">Forfattarane</term>
          <listitem>
            <para>
              <xsl:apply-templates select="//dc:creator" />
            </para>
          </listitem>
        </varlistentry>
        <varlistentry>
          <term lang="en">Proof Reading</term>
          <term lang="cs">Korektury</term>
          <term lang="de">Korrekturleser</term>
          <term lang="fr">Relectures</term>
          <term lang="it">Correzione e revisione</term>
          <term lang="ko">교정</term>
          <term lang="nl">Proef lezers</term>
          <term lang="no">Korrekturlesing</term>
          <listitem>
            <para>
              <xsl:apply-templates select="//dc:contributor" />
            </para>
          </listitem>
        </varlistentry>
      </variablelist>
    </sect1> 
  </xsl:template>
 
  <!-- two simple transformations -->
  <!-- they should be enhanced though -->
  <xsl:template match="//dc:creator">
    <xsl:apply-templates match="." />
    <xsl:text> (</xsl:text>
    <xsl:value-of select="@lang" />
    <xsl:text>),</xsl:text>
  </xsl:template>

  <xsl:template match="//dc:contributor">
    <xsl:apply-templates match="." />
    <xsl:text>, </xsl:text>
  </xsl:template>
</xsl:stylesheet>
