/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.test.internal.performance.db.DB;
import org.eclipse.test.internal.performance.db.Variations;
import org.osgi.framework.BundleContext;

public class PerformanceTestPlugin
extends Plugin {
    public static final String CONFIG = "config";
    public static final String BUILD = "build";
    private static final String DEFAULT_DB_NAME = "perfDB";
    private static final String DEFAULT_DB_USER = "guest";
    private static final String DEFAULT_DB_PASSWORD = "guest";
    private static final String DB_NAME = "dbname";
    private static final String DB_USER = "dbuser";
    private static final String DB_PASSWD = "dbpasswd";
    private static final String ECLIPSE_PERF_DBLOC = "eclipse.perf.dbloc";
    private static final String ECLIPSE_PERF_ASSERTAGAINST = "eclipse.perf.assertAgainst";
    private static final String ECLIPSE_PERF_CONFIG = "eclipse.perf.config";
    public static final String PLUGIN_ID = "org.eclipse.test.performance";
    public static final int INTERNAL_ERROR = 1;
    private static PerformanceTestPlugin fgPlugin;
    private static boolean fgOldDBInitialized;
    private static boolean fgOldDB;

    public PerformanceTestPlugin() {
        fgPlugin = this;
    }

    static boolean isOldDB() {
        if (!fgOldDBInitialized) {
            String loc = PerformanceTestPlugin.getDBLocation();
            if (loc != null && loc.indexOf("relengbuildserv") >= 0) {
                fgOldDB = true;
            }
            fgOldDBInitialized = true;
        }
        return fgOldDB;
    }

    public void stop(BundleContext context) throws Exception {
        DB.shutdown();
        super.stop(context);
    }

    public static PerformanceTestPlugin getDefault() {
        return fgPlugin;
    }

    public static String getDBLocation() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(ECLIPSE_PERF_DBLOC);
        }
        return null;
    }

    public static String getDBName() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_NAME, DEFAULT_DB_NAME);
        }
        return DEFAULT_DB_NAME;
    }

    public static String getDBUser() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_USER, "guest");
        }
        return "guest";
    }

    public static String getDBPassword() {
        String dbloc = System.getProperty(ECLIPSE_PERF_DBLOC);
        if (dbloc != null) {
            Variations keys = new Variations();
            keys.parsePairs("eclipse.perf.dbloc=" + dbloc);
            return keys.getProperty(DB_PASSWD, "guest");
        }
        return "guest";
    }

    public static Variations getVariations() {
        Variations keys = new Variations();
        String configKey = System.getProperty(ECLIPSE_PERF_CONFIG);
        if (configKey != null) {
            keys.parsePairs(configKey);
        }
        return keys;
    }

    public static Variations getAssertAgainst() {
        String assertKey = System.getProperty(ECLIPSE_PERF_ASSERTAGAINST);
        if (assertKey != null) {
            Variations keys = PerformanceTestPlugin.getVariations();
            if (keys == null) {
                keys = new Variations();
            }
            keys.parsePairs(assertKey);
            return keys;
        }
        return null;
    }

    public static void logError(String message) {
        if (message == null) {
            message = "";
        }
        PerformanceTestPlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, message, null));
    }

    public static void logWarning(String message) {
        if (message == null) {
            message = "";
        }
        PerformanceTestPlugin.log((IStatus)new Status(2, PLUGIN_ID, 0, message, null));
    }

    public static void log(Throwable e) {
        PerformanceTestPlugin.log((IStatus)new Status(4, PLUGIN_ID, 1, "Internal Error", e));
    }

    public static void log(IStatus status) {
        if (fgPlugin != null) {
            fgPlugin.getLog().log(status);
        } else {
            switch (status.getSeverity()) {
                case 4: {
                    System.err.println("Error: " + status.getMessage());
                    break;
                }
                case 2: {
                    System.err.println("Warning: " + status.getMessage());
                }
            }
            Throwable exception = status.getException();
            if (exception != null) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

