/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.violation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IBytecodeVisitor;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.ICodeAttribute;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IConstantPoolEntry;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.ILineNumberAttribute;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClassVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentUse;
import org.eclipse.wtp.releng.tools.component.api.FieldUse;
import org.eclipse.wtp.releng.tools.component.api.MethodUse;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.api.violation.LibVisitor;
import org.eclipse.wtp.releng.tools.component.internal.FieldRef;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.InternalByteCodeVisitor;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.MethodRef;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class Class2Reference
implements IPlatformRunnable,
IClassVisitor {
    private String src;
    private String outputDir;
    private Collection includes;
    private Collection excludes;
    private Collection includePlugins;
    private Collection excludePlugins;
    private boolean classRefOnly = false;
    private boolean debug = false;
    private boolean genHTML = false;
    private ComponentUse cachedCompUse;

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public Collection getExcludePlugins() {
        return this.excludePlugins;
    }

    public void setExcludePlugins(Collection excludePlugins) {
        this.excludePlugins = excludePlugins;
    }

    public Collection getIncludePlugins() {
        return this.includePlugins;
    }

    public void setIncludePlugins(Collection includePlugins) {
        this.includePlugins = includePlugins;
    }

    public boolean isClassRefOnly() {
        return this.classRefOnly;
    }

    public void setClassRefOnly(boolean classRefOnly) {
        this.classRefOnly = classRefOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isGenHTML() {
        return this.genHTML;
    }

    public void setGenHTML(boolean genHTML) {
        this.genHTML = genHTML;
    }

    public void execute() {
        ILocation srcLocation = Location.createLocation(new File(this.src));
        LibVisitor libVisitor = new LibVisitor();
        srcLocation.accept(libVisitor);
        libVisitor.setClassVisitor(this);
        srcLocation.accept(libVisitor);
        try {
            if (this.cachedCompUse != null) {
                this.cachedCompUse.save();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.isGenHTML()) {
            this.genHTML();
        }
    }

    public void genHTML() {
        ILocation outputLoc = Location.createLocation(new File(this.outputDir));
        outputLoc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().equals("component-use.xml")) {
                    try {
                        XSLUtil.transform(Platform.getBundle((String)"org.eclipse.wtp.releng.tools.component.core").getResource("org/eclipse/wtp/releng/tools/component/xsl/component-use.xsl").openStream(), location.getInputStream(), (OutputStream)new FileOutputStream(((FileLocation)location.createSibling("component-use.html")).getFile()));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                return true;
            }
        });
    }

    public boolean visit(String pluginId, ILocation classLoc) {
        if (this.includePlugins(pluginId)) {
            try {
                ComponentUse compUse = this.getComponentUse(pluginId);
                compUse.addSource(this.visit(classLoc));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (ClassFormatException classFormatException) {
                System.err.println("Plugin: " + pluginId + " Class: " + classLoc.getAbsolutePath());
            }
        }
        return true;
    }

    public Source visit(ILocation classLoc) throws IOException, ClassFormatException {
        IClassFileReader reader = this.read(classLoc);
        String className = new String(reader.getClassName()).replace('/', '.');
        Source source = new Source();
        source.setName(className);
        Iterator it = this.getReferencedTypes(reader).iterator();
        while (it.hasNext()) {
            String refClassName = (String)it.next();
            if (className.equals(refClassName) || !this.include(refClassName)) continue;
            this.setClassUse(source, refClassName, Boolean.TRUE, null, null, null, null);
        }
        this.setMethodAndFieldInfoUses(reader, source);
        if (!this.isClassRefOnly()) {
            String refClassName;
            ArrayList methodRefs = new ArrayList();
            ArrayList fieldRefs = new ArrayList();
            this.getRefs(reader, this.isDebug(), methodRefs, fieldRefs);
            Iterator it2 = methodRefs.iterator();
            while (it2.hasNext()) {
                MethodRef methodRef = (MethodRef)it2.next();
                refClassName = methodRef.getClassName();
                if (className.equals(refClassName) || !this.include(refClassName)) continue;
                String methodName = methodRef.getMethodName();
                ClassUse classUse = methodRef.isConstructor() ? this.setClassUse(source, refClassName, null, null, null, Boolean.TRUE, methodRef.getLines()) : this.setClassUse(source, refClassName, Boolean.TRUE, null, null, null, null);
                MethodUse methodUse = new MethodUse();
                methodUse.setName(methodName);
                methodUse.setDescriptor(methodRef.getMethodDescriptor());
                List lines = methodRef.getLines();
                if (lines != null) {
                    methodUse.addLines(lines);
                }
                classUse.addMethodAPI(methodUse);
            }
            methodRefs = null;
            it2 = fieldRefs.iterator();
            while (it2.hasNext()) {
                FieldRef fieldRef = (FieldRef)it2.next();
                refClassName = fieldRef.getClassName();
                if (className.equals(refClassName) || !this.include(refClassName)) continue;
                ClassUse classUse = this.setClassUse(source, refClassName, Boolean.TRUE, null, null, null, null);
                FieldUse fieldUse = new FieldUse();
                fieldUse.setName(fieldRef.getFieldName());
                fieldUse.setDescriptor(fieldRef.getFieldDescriptor());
                List lines = fieldRef.getLines();
                if (lines != null) {
                    fieldUse.addLines(lines);
                }
                classUse.addFieldAPI(fieldUse);
            }
            fieldRefs = null;
            String superClass = new String(reader.getSuperclassName()).replace('/', '.');
            if (superClass != null && this.include(superClass)) {
                this.setClassUse(source, superClass, null, Boolean.TRUE, null, null, null);
            }
            char[][] interfaceNames = reader.getInterfaceNames();
            String[] interfaces = new String[interfaceNames.length];
            int i = 0;
            while (i < interfaces.length) {
                interfaces[i] = new String(interfaceNames[i]).replace('/', '.');
                ++i;
            }
            i = 0;
            while (i < interfaces.length) {
                if (this.include(interfaces[i])) {
                    this.setClassUse(source, interfaces[i], null, null, Boolean.TRUE, null, null);
                }
                ++i;
            }
        }
        return source;
    }

    private IClassFileReader read(ILocation classLoc) throws IOException, ClassFormatException {
        ClassFileReader classFileReader;
        ByteArrayOutputStream baos;
        block11: {
            InputStream is = null;
            baos = null;
            try {
                byte[] b = new byte[8192];
                baos = new ByteArrayOutputStream(8192);
                is = classLoc.getInputStream();
                int read = is.read(b);
                while (read != -1) {
                    baos.write(b, 0, read);
                    read = is.read(b);
                }
                is.close();
                baos.close();
                classFileReader = new ClassFileReader(baos.toByteArray(), 47);
                Object var6_7 = null;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_8 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (baos == null) break block13;
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
    }

    private Set getReferencedTypes(IClassFileReader reader) {
        HashSet<String> types = new HashSet<String>();
        IConstantPool constantPool = reader.getConstantPool();
        int poolSize = constantPool.getConstantPoolCount();
        int i = 0;
        while (i < poolSize) {
            block3: {
                String signature;
                block4: {
                    if (constantPool.getEntryKind(i) != 7) break block3;
                    IConstantPoolEntry classEntry = constantPool.decodeEntry(i);
                    signature = new String(classEntry.getClassInfoName());
                    int index = signature.lastIndexOf(91);
                    if (index <= -1) break block4;
                    if (signature.length() - (index + 1) == 1) break block3;
                    signature = Signature.toString((String)signature);
                    signature = signature.substring(0, signature.length() - 2 * (index + 1));
                    signature = signature.replace('.', '$');
                }
                String typeName = signature.replace('/', '.');
                types.add(typeName);
            }
            ++i;
        }
        return types;
    }

    private void getRefs(IClassFileReader reader, boolean debug, List methodRefs, List fieldRefs) {
        MethodRef methodRef;
        String refClassName;
        String className = new String(reader.getClassName()).replace('/', '.');
        IConstantPoolEntry[] refs = this.getConstantPoolEntries(reader, 10);
        int i = 0;
        while (i < refs.length) {
            refClassName = new String(refs[i].getClassName()).replace('/', '.');
            if (!className.equals(refClassName) && this.include(refClassName)) {
                methodRef = new MethodRef();
                methodRef.setPoolEntry(refs[i]);
                methodRefs.add(methodRef);
            }
            ++i;
        }
        refs = this.getConstantPoolEntries(reader, 11);
        i = 0;
        while (i < refs.length) {
            refClassName = new String(refs[i].getClassName()).replace('/', '.');
            if (!className.equals(refClassName) && this.include(refClassName)) {
                methodRef = new MethodRef();
                methodRef.setPoolEntry(refs[i]);
                methodRefs.add(methodRef);
            }
            ++i;
        }
        refs = this.getConstantPoolEntries(reader, 9);
        i = 0;
        while (i < refs.length) {
            refClassName = new String(refs[i].getClassName()).replace('/', '.');
            if (!className.equals(refClassName) && this.include(refClassName)) {
                FieldRef fieldRef = new FieldRef();
                fieldRef.setPoolEntry(refs[i]);
                fieldRefs.add(fieldRef);
            }
            ++i;
        }
        if (debug) {
            IMethodInfo[] methodInfos = reader.getMethodInfos();
            int i2 = 0;
            while (i2 < methodInfos.length) {
                ILineNumberAttribute lineNumAttr;
                ICodeAttribute codeAttr = methodInfos[i2].getCodeAttribute();
                if (codeAttr != null && (lineNumAttr = codeAttr.getLineNumberAttribute()) != null) {
                    InternalByteCodeVisitor byteCodeVisitor = new InternalByteCodeVisitor(methodRefs, fieldRefs, lineNumAttr);
                    try {
                        codeAttr.traverse((IBytecodeVisitor)byteCodeVisitor);
                    }
                    catch (ClassFormatException e) {
                        e.printStackTrace();
                    }
                }
                ++i2;
            }
        }
    }

    private void setMethodAndFieldInfoUses(IClassFileReader reader, Source source) {
        String className = new String(reader.getClassName()).replace('/', '.');
        IMethodInfo[] methodInfos = reader.getMethodInfos();
        int i = 0;
        while (i < methodInfos.length) {
            String desc = new String(methodInfos[i].getDescriptor());
            String returnTypeDesc = Signature.getReturnType((String)desc);
            String returnType = this.toFullyQualifiedName(returnTypeDesc);
            if (Signature.getTypeSignatureKind((String)returnTypeDesc) != 2 && !className.equals(returnType) && this.include(returnType)) {
                this.setClassUse(source, returnType, Boolean.TRUE, null, null, null, null);
            }
            String[] params = Signature.getParameterTypes((String)desc);
            int j = 0;
            while (j < params.length) {
                String param = this.toFullyQualifiedName(params[j]);
                if (Signature.getTypeSignatureKind((String)params[j]) != 2 && !className.equals(param) && this.include(param)) {
                    this.setClassUse(source, param, Boolean.TRUE, null, null, null, null);
                }
                ++j;
            }
            String[] throwTypes = Signature.getThrownExceptionTypes((String)desc);
            int j2 = 0;
            while (j2 < throwTypes.length) {
                String throwType = this.toFullyQualifiedName(throwTypes[j2]);
                if (Signature.getTypeSignatureKind((String)throwTypes[j2]) != 2 && !className.equals(throwType) && this.include(throwType)) {
                    this.setClassUse(source, throwType, Boolean.TRUE, null, null, null, null);
                }
                ++j2;
            }
            ++i;
        }
        IFieldInfo[] fieldInfos = reader.getFieldInfos();
        int i2 = 0;
        while (i2 < fieldInfos.length) {
            String desc = new String(fieldInfos[i2].getDescriptor());
            String field = this.toFullyQualifiedName(desc);
            if (Signature.getTypeSignatureKind((String)desc) != 2 && !className.equals(field) && this.include(field)) {
                this.setClassUse(source, field, Boolean.TRUE, null, null, null, null);
            }
            ++i2;
        }
    }

    private String toFullyQualifiedName(String descriptor) {
        StringBuffer sb = new StringBuffer();
        descriptor = descriptor.replace('/', '.');
        sb.append(Signature.getSignatureQualifier((String)descriptor));
        sb.append('.');
        sb.append(Signature.getSignatureSimpleName((String)descriptor).replace('.', '$'));
        return sb.toString();
    }

    private IConstantPoolEntry[] getConstantPoolEntries(IClassFileReader reader, int kind) {
        Vector<IConstantPoolEntry> entries = new Vector<IConstantPoolEntry>();
        IConstantPool pool = reader.getConstantPool();
        int poolSize = pool.getConstantPoolCount();
        int i = 0;
        while (i < poolSize) {
            if (pool.getEntryKind(i) == kind) {
                entries.add(pool.decodeEntry(i));
            }
            ++i;
        }
        return entries.toArray(new IConstantPoolEntry[0]);
    }

    private ClassUse setClassUse(Source source, String className, Boolean ref, Boolean subclass, Boolean implement, Boolean instantiate, List lines) {
        ClassUse classUse = source.getClassUse(className);
        if (classUse == null) {
            classUse = new ClassUse();
            classUse.setName(className);
            source.addClassUse(classUse);
        }
        if (ref != null && ref.booleanValue()) {
            classUse.setReference(Boolean.TRUE);
        }
        if (subclass != null && subclass.booleanValue()) {
            classUse.setSubclass(Boolean.TRUE);
        }
        if (implement != null && implement.booleanValue()) {
            classUse.setImplement(Boolean.TRUE);
        }
        if (instantiate != null && instantiate.booleanValue()) {
            classUse.setInstantiate(Boolean.TRUE);
        }
        if (lines != null) {
            classUse.addLines(lines);
        }
        return classUse;
    }

    private boolean include(String name) {
        Iterator it;
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        if (this.excludes != null && !this.excludes.isEmpty()) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean includePlugins(String id) {
        Iterator it;
        id = id.replace('/', '.');
        id = id.replace('\\', '.');
        if (this.excludePlugins != null && !this.excludePlugins.isEmpty()) {
            it = this.excludePlugins.iterator();
            while (it.hasNext()) {
                if (!id.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includePlugins != null && !this.includePlugins.isEmpty()) {
            it = this.includePlugins.iterator();
            while (it.hasNext()) {
                if (!id.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ComponentUse getComponentUse(String id) throws IOException {
        if (this.cachedCompUse != null) {
            if (this.cachedCompUse.getName().equals(id)) {
                return this.cachedCompUse;
            }
            this.cachedCompUse.save();
        }
        StringBuffer sb = new StringBuffer(this.outputDir);
        sb.append(id);
        sb.append("/component-use.xml");
        File file = new File(sb.toString());
        this.cachedCompUse = new ComponentUse();
        this.cachedCompUse.setName(id);
        this.cachedCompUse.setLocation(new FileLocation(file));
        if (file.exists()) {
            this.cachedCompUse.load();
        }
        return this.cachedCompUse;
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public Object run(Object arguments) {
        String src = System.getProperty("src");
        String outputDir = System.getProperty("outputDir");
        String includes = System.getProperty("includes");
        String excludes = System.getProperty("excludes");
        String includePlugins = System.getProperty("includePlugins");
        String excludePlugins = System.getProperty("excludePlugins");
        String classRefOnly = System.getProperty("classRefOnly");
        String debug = System.getProperty("debug");
        String genHTML = System.getProperty("genHTML");
        ArrayList<String> args = new ArrayList<String>();
        args.add("-src");
        args.add(src);
        args.add("-outputDir");
        args.add(outputDir);
        if (includes != null) {
            args.add("-includes");
            args.addAll(this.tokenize(includes));
        }
        if (excludes != null) {
            args.add("excludes");
            args.addAll(this.tokenize(excludes));
        }
        if (includePlugins != null) {
            args.add("-includePlugins");
            args.addAll(this.tokenize(includePlugins));
        }
        if (excludePlugins != null) {
            args.add("-excludePlugins");
            args.addAll(this.tokenize(excludePlugins));
        }
        if (classRefOnly != null) {
            args.add("-classRefOnly");
        }
        if (debug != null) {
            args.add("-debug");
        }
        if (genHTML != null) {
            args.add("-genHTML");
        }
        try {
            Class2Reference.main(args.toArray(new String[0]));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return IPlatformRunnable.EXIT_OK;
    }

    private List tokenize(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
        }
        return tokens;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection src = (Collection)options.get("src");
        Collection outputDir = (Collection)options.get("outputDir");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        Collection includePlugins = (Collection)options.get("includePlugins");
        Collection excludePlugins = (Collection)options.get("excludePlugins");
        Collection classRefOnly = (Collection)options.get("classRefOnly");
        Collection debug = (Collection)options.get("debug");
        Collection genHTML = (Collection)options.get("genHTML");
        if (src == null || outputDir == null || src.isEmpty() || outputDir.isEmpty()) {
            Class2Reference.printUsage();
            System.exit(-1);
        }
        Class2Reference class2Ref = new Class2Reference();
        class2Ref.setSrc((String)src.iterator().next());
        class2Ref.setOutputDir((String)outputDir.iterator().next());
        class2Ref.setIncludes(includes);
        class2Ref.setExcludes(excludes);
        class2Ref.setIncludePlugins(includePlugins);
        class2Ref.setExcludePlugins(excludePlugins);
        class2Ref.setClassRefOnly(classRefOnly != null);
        class2Ref.setDebug(debug != null);
        class2Ref.setGenHTML(genHTML != null);
        class2Ref.execute();
    }

    public static void main(String src, String outputDir, Collection includes, Collection excludes, Collection includePlugins, Collection excludePlugins, boolean classRefOnly, boolean debug, boolean genHTML) {
        Class2Reference class2Ref = new Class2Reference();
        class2Ref.setSrc(src);
        class2Ref.setOutputDir(outputDir);
        class2Ref.setIncludes(includes);
        class2Ref.setExcludes(excludes);
        class2Ref.setIncludePlugins(includePlugins);
        class2Ref.setExcludePlugins(excludePlugins);
        class2Ref.setClassRefOnly(classRefOnly);
        class2Ref.setDebug(debug);
        class2Ref.setGenHTML(genHTML);
        class2Ref.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.classes.class2Reference -src <src> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-src\t\t<src>\t\tlocation of a Eclipse-based product");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated packages to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated packages to exclude");
        System.out.println("\t-includePlugins\t<includePlugins>\tspace seperated plugins to include");
        System.out.println("\t-excludePlugins\t<excludePlugins>\tspace seperated plugins to exclude");
        System.out.println("\t-classRefOnly\t\t\ttreat all violations as class reference");
        System.out.println("\t-debug\t\t\t\tgenerate debug information (ex. line numbers)");
        System.out.println("\t-genHTML\t\t\t\tgenerate HTML report");
    }
}

