/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api.progress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.api.progress.APIProgressEntry;
import org.eclipse.wtp.releng.tools.component.internal.ComponentSummary;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class APIProgressSummary
extends ComponentSummary {
    private List pluginsWithoutComp;
    private List missingPlugins;
    private List dupPlugins;

    public void addPluginsWithoutComp(List pluginIds) {
        if (this.pluginsWithoutComp == null) {
            this.pluginsWithoutComp = new ArrayList();
        }
        this.pluginsWithoutComp.addAll(pluginIds);
    }

    public void addMissingPlugins(List pluginIds) {
        if (this.missingPlugins == null) {
            this.missingPlugins = new ArrayList();
        }
        this.missingPlugins.addAll(pluginIds);
    }

    public void addDupPlugins(List pluginIds) {
        if (this.dupPlugins == null) {
            this.dupPlugins = new ArrayList();
        }
        this.dupPlugins.addAll(pluginIds);
    }

    public void load(ILocation location) throws ParserConfigurationException, SAXException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        parser.parse(new InputSource(new BufferedInputStream(location.getInputStream())), (DefaultHandler)new APIProgressSummaryHandler(this));
    }

    public String toString(String rootTagName) {
        StringBuffer sb = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<");
        sb.append(rootTagName);
        sb.append(">");
        Iterator it = this.getEntries().iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString());
        }
        if (this.pluginsWithoutComp != null) {
            it = this.pluginsWithoutComp.iterator();
            while (it.hasNext()) {
                sb.append("<plugin-without-comp").append(this.toAttribute("id", it.next().toString())).append("/>");
            }
        }
        if (this.missingPlugins != null) {
            it = this.missingPlugins.iterator();
            while (it.hasNext()) {
                sb.append("<missing-plugin").append(this.toAttribute("id", it.next().toString())).append("/>");
            }
        }
        if (this.dupPlugins != null) {
            it = this.dupPlugins.iterator();
            while (it.hasNext()) {
                sb.append("<dup-plugin").append(this.toAttribute("id", it.next().toString())).append("/>");
            }
        }
        sb.append("</");
        sb.append(rootTagName);
        sb.append(">");
        return sb.toString();
    }

    private String toAttribute(String key, String value) {
        StringBuffer sb = new StringBuffer();
        if (key != null && value != null) {
            sb.append(" ");
            sb.append(key);
            sb.append("=\"");
            sb.append(value);
            sb.append("\"");
        }
        return sb.toString();
    }

    private class APIProgressSummaryHandler
    extends DefaultHandler {
        private APIProgressSummary summary;

        public APIProgressSummaryHandler(APIProgressSummary summary) {
            this.summary = summary;
        }

        public void startElement(String uri, String elementName, String qName, Attributes attributes) throws SAXException {
            if ("component".equals(elementName) || "component".equals(qName)) {
                String name = attributes.getValue("name");
                String ref = attributes.getValue("ref");
                if (name != null && ref != null) {
                    APIProgressEntry entry = new APIProgressEntry();
                    entry.setCompName(name);
                    entry.setRef(ref);
                    this.summary.add(entry);
                }
            } else if ("component-summary".equals(elementName) || "component-summary".equals(qName)) {
                String timestamp = attributes.getValue("timestamp");
                this.summary.setTimestamp(timestamp);
            }
        }
    }
}

