/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IExceptionAttribute;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.util.ClassFileReader;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClassVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.api.ClassAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentAPI;
import org.eclipse.wtp.releng.tools.component.api.ComponentXMLVisitor;
import org.eclipse.wtp.releng.tools.component.api.FieldAPI;
import org.eclipse.wtp.releng.tools.component.api.MethodAPI;
import org.eclipse.wtp.releng.tools.component.api.PackageAPI;
import org.eclipse.wtp.releng.tools.component.api.violation.LibVisitor;
import org.eclipse.wtp.releng.tools.component.images.ImagesUtil;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.internal.Package;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.internal.Type;
import org.eclipse.wtp.releng.tools.component.xsl.XSLUtil;

public class API2ComponentAPI
implements IClassVisitor {
    private Collection api;
    private Collection src;
    private String outputDir;
    private Collection includes;
    private Collection excludes;
    private boolean html;
    private boolean readInterface = true;
    private boolean skipAPIGen = false;
    private Map interface2ImplClasses = new HashMap(0);
    private Map super2SubClasses = new HashMap(0);
    private boolean includeInnerClass = false;
    private boolean includeInterfaces = false;
    private Map pluginId2CompXML = new HashMap();
    private ComponentAPI cachedCompAPI;

    public Collection getApi() {
        return this.api;
    }

    public void setApi(String api) {
        this.api = new ArrayList(1);
        this.api.add(api);
    }

    public void setApi(Collection api) {
        this.api = api;
    }

    public Collection getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = new ArrayList(1);
        this.src.add(src);
    }

    public void setSrc(Collection src) {
        this.src = src;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outputDir) {
        this.outputDir = this.addTrailingSeperator(outputDir);
    }

    public Collection getIncludes() {
        return this.includes;
    }

    public void setIncludes(Collection includes) {
        this.includes = includes;
    }

    public Collection getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection excludes) {
        this.excludes = excludes;
    }

    public boolean isHtml() {
        return this.html;
    }

    public void setHtml(boolean html) {
        this.html = html;
    }

    public boolean isReadInterface() {
        return this.readInterface;
    }

    public void setReadInterface(boolean readInterface) {
        this.readInterface = readInterface;
    }

    public boolean isSkipAPIGen() {
        return this.skipAPIGen;
    }

    public void setSkipAPIGen(boolean skipAPIGen) {
        this.skipAPIGen = skipAPIGen;
    }

    public boolean isIncludeInnerClass() {
        return this.includeInnerClass;
    }

    public void setIncludeInnerClass(boolean includeInnerClass) {
        this.includeInnerClass = includeInnerClass;
    }

    public boolean isIncludeInterfaces() {
        return this.includeInterfaces;
    }

    public void setIncludeInterfaces(boolean includeInterfaces) {
        this.includeInterfaces = includeInterfaces;
    }

    public List getImplClasses(String interfaceName) {
        ArrayList list = new ArrayList();
        this.getImplClasses(interfaceName, list);
        return list;
    }

    private void getImplClasses(String interfaceName, List list) {
        List implClasses = (List)this.interface2ImplClasses.get(interfaceName);
        if (implClasses != null) {
            list.addAll(implClasses);
            Iterator it = implClasses.iterator();
            while (it.hasNext()) {
                String className = (String)it.next();
                if (this.interface2ImplClasses.get(className) != null) {
                    this.getImplClasses(className, list);
                    continue;
                }
                this.getSubClasses(className, list);
                this.getSuperClasses(className, list);
            }
        }
    }

    private void getSuperClasses(String className, List list) {
        ClassHierarchyInfo info = (ClassHierarchyInfo)this.super2SubClasses.get(className);
        if (info != null) {
            String superClassName = info.getSuperClass();
            while (superClassName != null) {
                list.add(superClassName);
                superClassName = null;
                info = (ClassHierarchyInfo)this.super2SubClasses.get(superClassName);
                if (info == null) continue;
                superClassName = info.getSuperClass();
            }
        }
    }

    private void getSubClasses(String className, List list) {
        List subClasses;
        ClassHierarchyInfo info = (ClassHierarchyInfo)this.super2SubClasses.get(className);
        if (info != null && (subClasses = info.getSubClass()) != null) {
            list.addAll(subClasses);
            Iterator it = subClasses.iterator();
            while (it.hasNext()) {
                this.getSubClasses((String)it.next(), list);
            }
        }
    }

    public void execute() {
        Iterator i = this.api.iterator();
        while (i.hasNext()) {
            ILocation apiLocation = Location.createLocation(new File((String)i.next()));
            ComponentXMLVisitor compXMLVisitor = new ComponentXMLVisitor();
            apiLocation.accept(compXMLVisitor);
            Iterator it = compXMLVisitor.getCompXMLs().iterator();
            while (it.hasNext()) {
                ComponentXML compXML = (ComponentXML)it.next();
                Iterator it2 = compXML.getPlugins().iterator();
                while (it2.hasNext()) {
                    this.pluginId2CompXML.put(((Plugin)it2.next()).getId(), compXML);
                }
            }
        }
        Iterator it = this.src.iterator();
        while (it.hasNext()) {
            ILocation srcLocation = Location.createLocation(new File((String)it.next()));
            LibVisitor libVisitor = new LibVisitor();
            if (srcLocation != null) {
                srcLocation.accept(libVisitor);
                libVisitor.setClassVisitor(this);
                srcLocation.accept(libVisitor);
                continue;
            }
            System.out.println("Null source location found, continuing.");
        }
        try {
            if (this.cachedCompAPI != null) {
                this.cachedCompAPI.save();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.isHtml()) {
            this.genHTML();
        }
    }

    private void genHTML() {
        ImagesUtil.copyAll(this.outputDir);
        final StringBuffer summary = new StringBuffer();
        summary.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        summary.append("<root>");
        ILocation outputLoc = Location.createLocation(new File(this.outputDir));
        outputLoc.accept(new ILocationVisitor(){

            public boolean accept(ILocation location) {
                if (location.getName().endsWith("api-info.xml")) {
                    summary.append("<api-info file=\"");
                    summary.append(location.getAbsolutePath().substring(API2ComponentAPI.this.outputDir.length()));
                    summary.append("\"/>");
                }
                return true;
            }
        });
        summary.append("</root>");
        try {
            XSLUtil.transform(ClassLoader.getSystemResourceAsStream("org/eclipse/wtp/releng/tools/component/xsl/api-info-summary.xsl"), new ByteArrayInputStream(summary.toString().getBytes()), (OutputStream)new FileOutputStream(new File(String.valueOf(this.outputDir) + "/api-info-summary.html")), this.outputDir);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean visit(String pluginId, ILocation classLoc) {
        block21: {
            try {
                IClassFileReader reader = this.read(classLoc);
                String className = new String(reader.getClassName()).replace('/', '.');
                if (!this.include(className)) break block21;
                int i = className.lastIndexOf(46);
                String packageName = i != -1 ? className.substring(0, i) : "";
                String localName = i != -1 ? className.substring(i + 1) : className;
                ClassAPIInfo classAPIInfo = this.isAPI(reader, pluginId, packageName, localName);
                boolean isAPI = classAPIInfo.api;
                if (this.readInterface) {
                    String superClassName = new String(reader.getSuperclassName()).replace('/', '.');
                    ClassHierarchyInfo info = new ClassHierarchyInfo();
                    info.setSuperClass(superClassName);
                    this.super2SubClasses.put(className, info);
                    info = (ClassHierarchyInfo)this.super2SubClasses.get(superClassName);
                    if (info == null) {
                        info = new ClassHierarchyInfo();
                        this.super2SubClasses.put(superClassName, info);
                    }
                    info.addSubClass(className);
                    char[][] names = reader.getInterfaceNames();
                    int j = 0;
                    while (j < names.length) {
                        String interfaceName = new String(names[j]).replace('/', '.');
                        ArrayList<String> implClasses = (ArrayList<String>)this.interface2ImplClasses.get(interfaceName);
                        if (implClasses == null) {
                            implClasses = new ArrayList<String>(1);
                            this.interface2ImplClasses.put(interfaceName, implClasses);
                        }
                        implClasses.add(className);
                        ++j;
                    }
                }
                if (this.isSkipAPIGen() || !isAPI) break block21;
                try {
                    ClassAPI classAPI;
                    ComponentAPI compAPI = this.getComponentAPI(pluginId);
                    PackageAPI pkgAPI = compAPI.getPackageAPI(packageName);
                    if (pkgAPI == null) {
                        pkgAPI = new PackageAPI();
                        pkgAPI.setName(packageName);
                        compAPI.addPackageAPI(pkgAPI);
                    }
                    if ((classAPI = pkgAPI.getClassAPI(localName)) == null) {
                        boolean isExclusive = this.isExclusive(pluginId, packageName);
                        if (reader == null) {
                            reader = this.read(classLoc);
                        }
                        classAPI = new ClassAPI();
                        classAPI.setName(localName);
                        classAPI.setAccess(reader.getAccessFlags());
                        classAPI.setSuperClass(new String(reader.getSuperclassName()).replace('/', '.'));
                        if (this.includeInterfaces) {
                            char[][] names = reader.getInterfaceNames();
                            int j = 0;
                            while (j < names.length) {
                                classAPI.addInterface(new String(names[j]).replace('/', '.'));
                                ++j;
                            }
                        }
                        pkgAPI.addClassAPI(classAPI);
                        IMethodInfo[] methods = reader.getMethodInfos();
                        int j = 0;
                        while (j < methods.length) {
                            int methodAccessFlag = methods[j].getAccessFlags();
                            if (!Modifier.isPrivate((int)methodAccessFlag) && (!isExclusive || Modifier.isPublic((int)methodAccessFlag) || classAPIInfo.subclass && Modifier.isProtected((int)methodAccessFlag))) {
                                MethodAPI methodAPI = new MethodAPI();
                                methodAPI.setName(new String(methods[j].getName()));
                                methodAPI.setAccess(methodAccessFlag);
                                methodAPI.setDescriptor(new String(methods[j].getDescriptor()));
                                IExceptionAttribute exceptionAttr = methods[j].getExceptionAttribute();
                                if (exceptionAttr != null) {
                                    char[][] exceptionNames = exceptionAttr.getExceptionNames();
                                    ArrayList<String> exceptions = new ArrayList<String>(exceptionNames.length);
                                    int k = 0;
                                    while (k < exceptionNames.length) {
                                        exceptions.add(new String(exceptionNames[k]).replace('/', '.'));
                                        ++k;
                                    }
                                    methodAPI.addThrows(exceptions);
                                }
                                classAPI.addMethodAPI(methodAPI);
                            }
                            ++j;
                        }
                        IFieldInfo[] fields = reader.getFieldInfos();
                        int j2 = 0;
                        while (j2 < fields.length) {
                            int fieldAccessFlag = fields[j2].getAccessFlags();
                            if (!Modifier.isPrivate((int)fieldAccessFlag) && (!isExclusive || Modifier.isPublic((int)fieldAccessFlag) || Modifier.isProtected((int)fieldAccessFlag))) {
                                FieldAPI fieldAPI = new FieldAPI();
                                fieldAPI.setName(new String(fields[j2].getName()));
                                fieldAPI.setAccess(fieldAccessFlag);
                                fieldAPI.setDescriptor(new String(fields[j2].getDescriptor()));
                                classAPI.addFieldAPI(fieldAPI);
                            }
                            ++j2;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (ClassFormatException e) {
                    throw new RuntimeException(e);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (ClassFormatException cfe) {
                cfe.printStackTrace();
            }
        }
        return true;
    }

    private ClassAPIInfo isAPI(IClassFileReader reader, String pluginId, String packageName, String localName) {
        boolean innerClass = localName.indexOf(36) != -1;
        int classAccessFlag = reader.getAccessFlags();
        if (Modifier.isPrivate((int)classAccessFlag)) {
            return new ClassAPIInfo(false, false);
        }
        if (!this.includeInnerClass && innerClass && !Modifier.isPublic((int)classAccessFlag) && !Modifier.isProtected((int)classAccessFlag)) {
            return new ClassAPIInfo(false, false);
        }
        ComponentXML compXML = (ComponentXML)this.pluginId2CompXML.get(pluginId);
        if (compXML != null) {
            Package pkg = compXML.getPackage(packageName);
            if (pkg != null) {
                if (pkg.isExclusive() && !Modifier.isPublic((int)classAccessFlag) && !Modifier.isProtected((int)classAccessFlag)) {
                    return new ClassAPIInfo(false, false);
                }
                int innerClassSep = localName.indexOf(36);
                Type type = innerClassSep == -1 ? pkg.getType(localName) : pkg.getType(localName.substring(0, innerClassSep));
                if (type != null) {
                    if (!(type.isReference() || type.isSubclass() || type.isImplement() || type.isInstantiate())) {
                        return new ClassAPIInfo(false, false);
                    }
                    return new ClassAPIInfo(true, type.isSubclass());
                }
                return new ClassAPIInfo(pkg.isApi(), true);
            }
            return new ClassAPIInfo(false, false);
        }
        return new ClassAPIInfo(false, false);
    }

    private boolean isExclusive(String pluginId, String packageName) {
        Package pkg;
        ComponentXML compXML = (ComponentXML)this.pluginId2CompXML.get(pluginId);
        if (compXML != null && (pkg = compXML.getPackage(packageName)) != null) {
            return pkg.isExclusive();
        }
        return true;
    }

    private IClassFileReader read(ILocation classLoc) throws IOException, ClassFormatException {
        ClassFileReader classFileReader;
        ByteArrayOutputStream baos;
        block11: {
            InputStream is = null;
            baos = null;
            try {
                byte[] b = new byte[8192];
                baos = new ByteArrayOutputStream(8192);
                is = classLoc.getInputStream();
                int read = is.read(b);
                while (read != -1) {
                    baos.write(b, 0, read);
                    read = is.read(b);
                }
                is.close();
                baos.close();
                classFileReader = new ClassFileReader(baos.toByteArray(), 15);
                Object var6_7 = null;
                if (is == null) break block11;
            }
            catch (Throwable throwable) {
                block13: {
                    Object var6_8 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (baos == null) break block13;
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (baos != null) {
            try {
                baos.close();
            }
            catch (IOException iOException) {}
        }
        return classFileReader;
    }

    private boolean include(String name) {
        Iterator it;
        name = name.replace('/', '.');
        name = name.replace('\\', '.');
        if (this.excludes != null && !this.excludes.isEmpty()) {
            it = this.excludes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return false;
            }
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            it = this.includes.iterator();
            while (it.hasNext()) {
                if (!name.matches((String)it.next())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private ComponentAPI getComponentAPI(String id) throws IOException {
        if (this.cachedCompAPI != null) {
            if (this.cachedCompAPI.getName().equals(id)) {
                return this.cachedCompAPI;
            }
            this.cachedCompAPI.save();
        }
        StringBuffer sb = new StringBuffer(this.outputDir);
        sb.append(id);
        sb.append("/api-info.xml");
        File file = new File(sb.toString());
        this.cachedCompAPI = new ComponentAPI();
        this.cachedCompAPI.setName(id);
        this.cachedCompAPI.setLocation(new FileLocation(file));
        if (file.exists()) {
            this.cachedCompAPI.load();
        }
        return this.cachedCompAPI;
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        Collection api = (Collection)options.get("api");
        Collection src = (Collection)options.get("src");
        Collection outputDir = (Collection)options.get("outputDir");
        Collection includes = (Collection)options.get("includes");
        Collection excludes = (Collection)options.get("excludes");
        Collection html = (Collection)options.get("html");
        if (api == null || src == null || outputDir == null || api.isEmpty() || src.isEmpty() || outputDir.isEmpty()) {
            API2ComponentAPI.printUsage();
            System.exit(-1);
        }
        API2ComponentAPI api2CompAPI = new API2ComponentAPI();
        api2CompAPI.setApi(api);
        api2CompAPI.setSrc(src);
        api2CompAPI.setOutputDir((String)outputDir.iterator().next());
        api2CompAPI.setIncludes(includes);
        api2CompAPI.setExcludes(excludes);
        api2CompAPI.setHtml(html != null);
        api2CompAPI.execute();
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.api.API2ComponentAPI -api <api> -src <src> -outputDir <outputDir> [-options]");
        System.out.println("");
        System.out.println("\t-api\t\t<api>\t\tlocation of your component.xml");
        System.out.println("\t-src\t\t<src>\t\tlocation of a Eclipse-based product");
        System.out.println("\t-outputDir\t<outputDir>\toutput directory of component.xml files");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-includes\t<includes>\tspace seperated packages to include");
        System.out.println("\t-excludes\t<excludes>\tspace seperated packages to exclude");
        System.out.println("\t-html\t\t\t\t\tgenerate HTML output");
    }

    private class ClassAPIInfo {
        public boolean api;
        public boolean subclass;

        public ClassAPIInfo(boolean api, boolean subclass) {
            this.api = api;
            this.subclass = subclass;
        }
    }

    private class ClassHierarchyInfo {
        private String superClass;
        private List subClass;

        private ClassHierarchyInfo() {
        }

        public List getSubClass() {
            return this.subClass;
        }

        public void addSubClass(String subClass) {
            if (this.subClass == null) {
                this.subClass = new ArrayList(1);
            }
            this.subClass.add(subClass);
        }

        public String getSuperClass() {
            return this.superClass;
        }

        public void setSuperClass(String superClass) {
            this.superClass = superClass;
        }
    }
}

