/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.internal.ui.wizards.PluginSelectionDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.wtp.releng.tools.component.internal.ComponentDepends;
import org.eclipse.wtp.releng.tools.component.internal.ComponentRef;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Description;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.ui.ComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentRefDialog;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentXMLEditor;
import org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentXMLProvider;

public class ComponentPage
extends FormPage {
    public static final String ID = "org.eclipse.wtp.releng.tools.component.ui.internal.editor.ComponentPage";
    private final Color BLUE = new Color((Device)Display.getDefault(), 0, 0, 255);
    private final char KEY_DEL = (char)127;
    private Text name;
    private Text overviewURL;
    private Button unrestrictedDepends;
    private Button addCompRef;
    private Tree compRefs;
    private Tree plugins;
    private TreeViewer compRefsViewer;
    private TreeViewer pluginsViewer;

    public ComponentPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public ComponentPage(String id, String title) {
        super(id, title);
    }

    private void init() {
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        ComponentXML compXML = editor.getComponentXML();
        String compName = compXML.getName();
        this.name.setText(compName != null ? compName : "");
        Description description = compXML.getDescription();
        this.overviewURL.setText(description != null && description.getUrl() != null ? description.getUrl() : "");
        ComponentDepends depends = compXML.getComponentDepends();
        boolean isUnrestricted = depends.isUnrestricted();
        this.unrestrictedDepends.setSelection(isUnrestricted);
        this.addCompRef.setEnabled(!isUnrestricted);
        this.compRefsViewer = new TreeViewer(this.compRefs);
        ComponentXMLProvider compRefsProvider = new ComponentXMLProvider(0);
        this.compRefsViewer.setContentProvider((IContentProvider)compRefsProvider);
        this.compRefsViewer.setLabelProvider((IBaseLabelProvider)compRefsProvider);
        this.compRefsViewer.setInput((Object)depends);
        this.pluginsViewer = new TreeViewer(this.plugins);
        ComponentXMLProvider pluginsProvider = new ComponentXMLProvider(1);
        this.pluginsViewer.setContentProvider((IContentProvider)pluginsProvider);
        this.pluginsViewer.setLabelProvider((IBaseLabelProvider)pluginsProvider);
        this.pluginsViewer.setInput((Object)compXML);
        editor.setDirty(false);
    }

    protected void createFormContent(IManagedForm managedForm) {
        ComponentManager manager = ComponentManager.getManager();
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(manager.getMessage("PAGE_COMPONENT"));
        Composite body = form.getBody();
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.makeColumnsEqualWidth = true;
        gl.marginWidth = 10;
        gl.verticalSpacing = 20;
        gl.horizontalSpacing = 20;
        body.setLayout((Layout)gl);
        FormToolkit toolkit = managedForm.getToolkit();
        this.createLeftColumn(managedForm, toolkit.createComposite(body));
        this.createRightColumn(managedForm, toolkit.createComposite(body));
        toolkit.paintBordersFor(body);
        this.init();
    }

    private void createLeftColumn(IManagedForm managedForm, Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 5;
        gl.marginHeight = 5;
        gl.verticalSpacing = 10;
        parent.setLayout((Layout)gl);
        parent.setLayoutData((Object)new GridData(1808));
        FormToolkit toolkit = managedForm.getToolkit();
        Composite generalInfo = toolkit.createComposite(parent);
        Composite compDepends = toolkit.createComposite(parent);
        this.createGeneralInfo(managedForm, generalInfo);
        this.createComponentDepends(managedForm, compDepends);
        toolkit.paintBordersFor(parent);
    }

    private void createRightColumn(IManagedForm managedForm, Composite parent) {
        this.createPlugins(managedForm, parent);
    }

    private void createGeneralInfo(IManagedForm managedForm, Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 1;
        gl.marginHeight = 5;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(768);
        parent.setLayoutData((Object)gd);
        ComponentManager manager = ComponentManager.getManager();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.createLabel(parent, manager.getMessage("SECTION_DESC_GENERAL_INFO"));
        Composite innerComposite = toolkit.createComposite(parent);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        gl2.marginWidth = 1;
        gl2.marginHeight = 1;
        innerComposite.setLayout((Layout)gl2);
        innerComposite.setLayoutData((Object)gd);
        Label nameLabel = toolkit.createLabel(innerComposite, manager.getMessage("LABEL_NAME"));
        nameLabel.setForeground(this.BLUE);
        Composite nameComposite = toolkit.createComposite(innerComposite);
        nameComposite.setLayout((Layout)gl);
        nameComposite.setLayoutData((Object)gd);
        this.name = toolkit.createText(nameComposite, "");
        this.name.setLayoutData((Object)gd);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ComponentPage.this.modifyNameEvent(event);
            }
        });
        Label overviewURLLabel = toolkit.createLabel(innerComposite, manager.getMessage("LABEL_OVERVIEW_URL"));
        overviewURLLabel.setForeground(this.BLUE);
        Composite overviewURLComposite = toolkit.createComposite(innerComposite);
        overviewURLComposite.setLayout((Layout)gl);
        overviewURLComposite.setLayoutData((Object)gd);
        this.overviewURL = toolkit.createText(overviewURLComposite, "");
        this.overviewURL.setLayoutData((Object)gd);
        this.overviewURL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                ComponentPage.this.modifyOverviewURLEvent(event);
            }
        });
        toolkit.paintBordersFor(nameComposite);
        toolkit.paintBordersFor(overviewURLComposite);
        toolkit.paintBordersFor(innerComposite);
        toolkit.paintBordersFor(parent);
    }

    private void createComponentDepends(IManagedForm managedForm, Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 1;
        gl.marginHeight = 6;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        ComponentManager manager = ComponentManager.getManager();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.createLabel(parent, manager.getMessage("SECTION_DESC_COMPONENT_DEPENDS"));
        this.unrestrictedDepends = toolkit.createButton(parent, manager.getMessage("LABEL_UNRESTRICTED_COMPONENT_DEPENDS"), 32);
        this.unrestrictedDepends.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ComponentPage.this.unrestrictedDependsEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ComponentPage.this.unrestrictedDependsEvent(event);
            }
        });
        toolkit.createLabel(parent, manager.getMessage("LABEL_COMPONENT_REFS"));
        Composite compRefsComposite = toolkit.createComposite(parent);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        gl2.marginWidth = 1;
        gl2.marginHeight = 1;
        compRefsComposite.setLayout((Layout)gl2);
        compRefsComposite.setLayoutData((Object)gd);
        this.compRefs = toolkit.createTree(compRefsComposite, 2);
        this.compRefs.setLayout((Layout)gl);
        this.compRefs.setLayoutData((Object)gd);
        this.compRefs.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                ComponentPage.this.compRefKeyEvent(event);
            }
        });
        this.addCompRef = toolkit.createButton(compRefsComposite, manager.getMessage("LABEL_ADD"), 8);
        this.addCompRef.setLayoutData((Object)new GridData(2));
        this.addCompRef.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ComponentPage.this.addCompRefEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ComponentPage.this.addCompRefEvent(event);
            }
        });
        toolkit.paintBordersFor(compRefsComposite);
        toolkit.paintBordersFor(parent);
    }

    private void createPlugins(IManagedForm managedForm, Composite parent) {
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        gl.marginWidth = 1;
        gl.marginHeight = 6;
        parent.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        ComponentManager manager = ComponentManager.getManager();
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.createLabel(parent, manager.getMessage("SECTION_DESC_PLUGINS"));
        toolkit.createLabel(parent, manager.getMessage("LABEL_PLUGINS"));
        Composite pluginsComposite = toolkit.createComposite(parent);
        GridLayout gl2 = new GridLayout();
        gl2.numColumns = 2;
        gl2.marginWidth = 1;
        gl2.marginHeight = 1;
        pluginsComposite.setLayout((Layout)gl2);
        pluginsComposite.setLayoutData((Object)gd);
        this.plugins = toolkit.createTree(pluginsComposite, 2);
        this.plugins.setLayout((Layout)gl);
        this.plugins.setLayoutData((Object)gd);
        this.plugins.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent event) {
            }

            public void keyReleased(KeyEvent event) {
                ComponentPage.this.pluginKeyEvent(event);
            }
        });
        Button addPlugin = toolkit.createButton(pluginsComposite, manager.getMessage("LABEL_ADD"), 8);
        addPlugin.setLayoutData((Object)new GridData(2));
        addPlugin.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                ComponentPage.this.addPluginEvent(event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                ComponentPage.this.addPluginEvent(event);
            }
        });
        toolkit.paintBordersFor(pluginsComposite);
        toolkit.paintBordersFor(parent);
    }

    private void modifyNameEvent(ModifyEvent event) {
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        editor.getComponentXML().setName(this.name.getText());
        editor.setDirty(true);
    }

    private void modifyOverviewURLEvent(ModifyEvent event) {
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        ComponentXML compXML = editor.getComponentXML();
        Description description = compXML.getDescription();
        if (description == null) {
            description = new Description();
            compXML.setDescription(description);
        }
        description.setUrl(this.overviewURL.getText());
        editor.setDirty(true);
    }

    private void unrestrictedDependsEvent(SelectionEvent event) {
        boolean isUnrestricted = this.unrestrictedDepends.getSelection();
        this.compRefs.setEnabled(!isUnrestricted);
        this.addCompRef.setEnabled(!isUnrestricted);
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        editor.getComponentXML().getComponentDepends().setUnrestricted(isUnrestricted ? Boolean.TRUE : Boolean.FALSE);
        editor.setDirty(true);
    }

    private void compRefKeyEvent(KeyEvent event) {
        TreeItem[] items;
        if (event.character == '\u007f' && (items = this.compRefs.getSelection()).length > 0) {
            ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
            Collection refs = editor.getComponentXML().getComponentDepends().getComponentRefs();
            int i = 0;
            while (i < items.length) {
                refs.remove(items[i].getData());
                ++i;
            }
            this.compRefsViewer.refresh();
            editor.setDirty(true);
        }
    }

    private void addCompRefEvent(SelectionEvent event) {
        String[] compNames;
        ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
        ComponentDepends depends = editor.getComponentXML().getComponentDepends();
        Collection refs = depends.getComponentRefs();
        ArrayList<String> ignoreNames = new ArrayList<String>(refs.size() + 1);
        Iterator it = refs.iterator();
        while (it.hasNext()) {
            ignoreNames.add(((ComponentRef)it.next()).getName());
        }
        ignoreNames.add(this.name.getText());
        ComponentRefDialog dialog = new ComponentRefDialog(this.getEditor().getSite().getShell(), ignoreNames);
        if (dialog.open() == 0 && (compNames = dialog.getCompNames()).length > 0) {
            int i = 0;
            while (i < compNames.length) {
                ComponentRef ref = new ComponentRef();
                ref.setName(compNames[i]);
                refs.add(ref);
                ++i;
            }
            editor.setDirty(true);
            this.compRefsViewer.refresh();
        }
    }

    private void pluginKeyEvent(KeyEvent event) {
        TreeItem[] items;
        if (event.character == '\u007f' && (items = this.plugins.getSelection()).length > 0) {
            ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
            Collection pluginList = editor.getComponentXML().getPlugins();
            int i = 0;
            while (i < items.length) {
                pluginList.remove(items[i].getData());
                ++i;
            }
            this.pluginsViewer.refresh();
            editor.setDirty(true);
        }
    }

    private void addPluginEvent(SelectionEvent event) {
        Object[] results;
        PluginSelectionDialog dialog = new PluginSelectionDialog(this.getEditor().getSite().getShell(), true, true);
        if (dialog.open() == 0 && (results = dialog.getResult()).length > 0) {
            ComponentXMLEditor editor = (ComponentXMLEditor)this.getEditor();
            Collection pluginList = editor.getComponentXML().getPlugins();
            boolean added = false;
            int i = 0;
            while (i < results.length) {
                String fragmentId;
                if (results[i] instanceof IPluginModel) {
                    String pluginId = ((IPluginModel)results[i]).getPlugin().getId();
                    if (this.isNewPlugin(pluginId)) {
                        Plugin plugin = new Plugin();
                        plugin.setId(pluginId);
                        plugin.setFragment(Boolean.FALSE);
                        pluginList.add(plugin);
                        added = true;
                    }
                } else if (results[i] instanceof IFragmentModel && this.isNewPlugin(fragmentId = ((IFragmentModel)results[i]).getFragment().getId())) {
                    Plugin fragment = new Plugin();
                    fragment.setId(fragmentId);
                    fragment.setFragment(Boolean.TRUE);
                    pluginList.add(fragment);
                    added = true;
                }
                ++i;
            }
            if (added) {
                this.pluginsViewer.refresh();
                editor.setDirty(true);
            }
        }
    }

    private boolean isNewPlugin(String pluginId) {
        TreeItem[] items = this.plugins.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(pluginId)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

