/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui.internal.action;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationVisitor;
import org.eclipse.wtp.releng.tools.component.adopters.Java2API;
import org.eclipse.wtp.releng.tools.component.api.ComponentXMLVisitor;
import org.eclipse.wtp.releng.tools.component.api.violation.NonAPIDependencyScanner;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Location;
import org.eclipse.wtp.releng.tools.component.ui.internal.ComponentUIPlugin;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;
import org.osgi.service.prefs.Preferences;

public class Scan4NonAPIDependency
extends Action
implements IActionDelegate {
    public void run() {
        Object firstElement;
        IStructuredSelection selection;
        IPreferencesService prefService = Platform.getPreferencesService();
        IEclipsePreferences eclipsePref = prefService.getRootNode();
        Preferences pdePref = eclipsePref.node("/instance/org.eclipse.pde.core");
        String platformPath = pdePref.get("platform_path", null);
        String src = platformPath != null ? platformPath : Platform.getInstallLocation().toString();
        IPath outputDir = Platform.getPluginStateLocation((Plugin)ComponentUIPlugin.getDefault());
        String compXMLOutputDir = outputDir.addTrailingSeparator().append(src.replace(':', '_').replace('/', '_').replace('\\', '_')).toString();
        if (!new File(compXMLOutputDir).exists()) {
            ArrayList<String> excludePlugins = new ArrayList<String>();
            ComponentXMLVisitor compXMLVisitor = new ComponentXMLVisitor();
            Location.createLocation((File)new File(src)).accept((ILocationVisitor)compXMLVisitor);
            Iterator it = compXMLVisitor.getCompXMLs().iterator();
            while (it.hasNext()) {
                ComponentXML compXML = (ComponentXML)it.next();
                Iterator it2 = compXML.getPlugins().iterator();
                while (it2.hasNext()) {
                    org.eclipse.wtp.releng.tools.component.internal.Plugin plugin = (org.eclipse.wtp.releng.tools.component.internal.Plugin)it2.next();
                    excludePlugins.add(plugin.getId());
                }
            }
            ArrayList<String> excludes = new ArrayList<String>(1);
            excludes.add(".*internal.*");
            Java2API java2api = new Java2API();
            java2api.setSrc(src);
            java2api.setOutputDir(compXMLOutputDir);
            java2api.setExcludes(excludes);
            java2api.setExcludePlugins(excludePlugins);
            java2api.execute();
        }
        String reportOutputDir = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = (IStructuredSelection)window.getSelectionService().getSelection()) != null && !selection.isEmpty() && (firstElement = selection.getFirstElement()) != null && firstElement instanceof IFile) {
            try {
                IFile file = (IFile)firstElement;
                WorkspaceFileLocation compXMLLoc = new WorkspaceFileLocation(file);
                ComponentXML selectedCompXML = new ComponentXML();
                selectedCompXML.setLocation((ILocation)compXMLLoc);
                selectedCompXML.load();
                Collection plugins = selectedCompXML.getPlugins();
                ArrayList<String> srcs = new ArrayList<String>(plugins.size());
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IPath workspace = workspaceRoot.getLocation();
                Iterator it = plugins.iterator();
                while (it.hasNext()) {
                    org.eclipse.wtp.releng.tools.component.internal.Plugin plugin = (org.eclipse.wtp.releng.tools.component.internal.Plugin)it.next();
                    IProject project = workspaceRoot.getProject(plugin.getId());
                    if (!project.exists()) continue;
                    srcs.add(workspace.append(project.getFullPath()).toFile().toURL().toString().substring(6));
                }
                reportOutputDir = outputDir.append("_output_").toString();
                this.delete(new File(reportOutputDir));
                String[] args = new String[srcs.size() + 13];
                int i = 0;
                args[i++] = "-src";
                Iterator it2 = srcs.iterator();
                while (it2.hasNext()) {
                    args[i++] = (String)it2.next();
                }
                args[i++] = "-api";
                args[i++] = compXMLLoc.getAbsolutePath();
                args[i++] = "-outputDir";
                args[i++] = reportOutputDir;
                args[i++] = "-refapi";
                args[i++] = compXMLOutputDir;
                args[i++] = "-includes";
                args[i++] = "org.eclipse.*";
                NonAPIDependencyScanner.main((String[])args);
            }
            catch (Throwable ioe) {
                ioe.printStackTrace();
            }
        }
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser("org.eclipse.wtp.releng.tools.component.ui.internal.action.Scan4APIViolation");
            browser.openURL(new File(String.valueOf(reportOutputDir) + "/component-api-violation-all.html").toURL());
        }
        catch (PartInitException partInitException) {
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private boolean delete(File file) {
        String name = file.getName();
        if (name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".html")) {
            return true;
        }
        if (file.isDirectory()) {
            boolean b = true;
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                if (!this.delete(children[i])) {
                    b = false;
                }
                ++i;
            }
            return b;
        }
        return file.delete();
    }
}

