/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.document.DTDModelImpl;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.TextRegionListImpl;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.w3c.dom.Node;

public abstract class DTDNode
extends NodeContainer
implements IndexedRegion {
    protected DTDFile dtdFile;
    protected IStructuredDocumentRegion flatNode;
    protected TextRegionListImpl regions = new TextRegionListImpl();
    protected TextRegionListImpl whitespace = new TextRegionListImpl();

    public DTDNode(DTDFile dtdFile, IStructuredDocumentRegion flatNode) {
        this.dtdFile = dtdFile;
        this.flatNode = flatNode;
    }

    public void addRegion(ITextRegion region) {
        this.regions.add(region);
    }

    public void addWhitespaceRegion(ITextRegion region) {
        this.whitespace.add(region);
    }

    public void beginRecording(Object requestor, String label) {
        this.getDTDFile().getDTDModel().beginRecording(requestor, label);
    }

    public Node cloneNode(boolean deepest) {
        return null;
    }

    public boolean contains(int testPosition) {
        return this.containsRange(testPosition, testPosition);
    }

    public boolean containsRange(int start, int end) {
        return this.getStartOffset() <= start && end <= this.getEndOffset();
    }

    public void delete(DTDNode child) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_DTD_NODE_DELETE);
        this.delete((Object)this, child);
        this.endRecording((Object)this);
    }

    public void delete(Object requestor, DTDNode child) {
        this.replaceText(requestor, child.getStartOffset(), child.getFullNodeLength(), "");
    }

    public void endRecording(Object requestor) {
        this.getDTDFile().getDTDModel().endRecording(requestor);
    }

    public Object[] getChildren() {
        return this.getChildrenList().toArray();
    }

    public List getChildrenList() {
        Node child = this.getFirstChild();
        if (child != null) {
            ArrayList<Node> children = new ArrayList<Node>();
            while (child != null) {
                children.add(child);
                child = child.getNextSibling();
            }
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    public DTDNode getDeepestNode(int offset) {
        if (this.contains(offset)) {
            Object[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                DTDNode child = (DTDNode)((Object)children[i]);
                DTDNode deepest = child.getDeepestNode(offset);
                if (deepest != null) {
                    return deepest;
                }
                ++i;
            }
            return this;
        }
        return null;
    }

    public DTDNode getDeepestNode(int start, int end) {
        if (this.containsRange(start, end)) {
            Object[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                DTDNode child = (DTDNode)((Object)children[i]);
                DTDNode deepest = child.getDeepestNode(start, end);
                if (deepest != null) {
                    return deepest;
                }
                ++i;
            }
            return this;
        }
        return null;
    }

    public DTDFile getDTDFile() {
        return this.dtdFile;
    }

    public int getEndOffset() {
        return this.getStructuredDTDDocumentRegion().getEndOffset(this.getEndRegion());
    }

    public ITextRegion getEndRegion() {
        return this.regions.get(this.regions.size() - 1);
    }

    public FactoryRegistry getFactoryRegistry() {
        FactoryRegistry reg;
        DTDModelImpl model = this.dtdFile.getDTDModel();
        if (model != null && (reg = model.getFactoryRegistry()) != null) {
            return reg;
        }
        return null;
    }

    public int getFullNodeLength() {
        return this.getWhitespaceEndOffset() - this.getStartOffset();
    }

    public String getFullNodeText() {
        String text = this.getNodeText();
        if (this.whitespace.size() > 0) {
            RegionIterator iter = new RegionIterator((ITextRegionList)this.whitespace);
            while (iter.hasNext()) {
                ITextRegion region = iter.next();
                text = String.valueOf(text) + this.getStructuredDTDDocumentRegion().getText(region);
            }
        }
        return text;
    }

    public abstract Image getImage();

    public String getName() {
        ITextRegion region = this.getNameRegion();
        if (region != null) {
            return this.getStructuredDTDDocumentRegion().getText(region);
        }
        return "";
    }

    public ITextRegion getNameRegion() {
        RegionIterator iter = this.iterator();
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (region.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME") continue;
            return region;
        }
        return null;
    }

    public ITextRegion getNextRegion(RegionIterator iter, String type) {
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            if (!region.getType().equals(type)) continue;
            return region;
        }
        return null;
    }

    public int getNodeLength() {
        return this.getEndOffset() - this.getStartOffset();
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeText() {
        StringBuffer sb = new StringBuffer();
        RegionIterator iter = this.iterator();
        while (iter.hasNext()) {
            ITextRegion region = iter.next();
            sb.append(this.getStructuredDTDDocumentRegion().getText(region));
        }
        return sb.toString();
    }

    public short getNodeType() {
        return -1;
    }

    public int getStartOffset() {
        return this.getStructuredDTDDocumentRegion().getStartOffset(this.getStartRegion());
    }

    public ITextRegion getStartRegion() {
        return this.regions.get(0);
    }

    public IStructuredDocumentRegion getStructuredDTDDocumentRegion() {
        return this.flatNode;
    }

    public int getWhitespaceEndOffset() {
        if (this.whitespace.size() > 0) {
            ITextRegion region = this.whitespace.get(this.whitespace.size() - 1);
            return this.getStructuredDTDDocumentRegion().getEndOffset(region);
        }
        return this.getEndOffset();
    }

    public boolean hasTrailingWhitespace() {
        return this.whitespace.size() > 0;
    }

    public RegionIterator iterator() {
        return new RegionIterator((ITextRegionList)this.regions);
    }

    public void replaceText(Object requestor, int start, int length, String newText) {
        this.getDTDFile().getStructuredDocument().replaceText(requestor, start, length, newText);
    }

    public void resolveRegions() {
    }

    public void setName(Object requestor, String name) {
        ITextRegion nameRegion;
        if (!this.getName().equals(name) && (nameRegion = this.getNameRegion()) != null) {
            this.getDTDFile().getDTDModel().getReferenceUpdater().nameAboutToChange(requestor, this, name);
            this.replaceText(requestor, this.getStructuredDTDDocumentRegion().getStartOffset(nameRegion), nameRegion.getLength(), name);
        }
    }

    public void setName(String name) {
        this.beginRecording((Object)this, DTDCoreMessages._UI_LABEL_DTD_NODE_NAME_CHG);
        this.setName((Object)this, name);
        this.endRecording((Object)this);
    }

    void setStructuredDTDDocumentRegion(IStructuredDocumentRegion v) {
        this.flatNode = v;
    }

    protected void skipPastName(RegionIterator iter) {
        while (iter.hasNext()) {
            ITextRegion currentRegion = iter.next();
            if (currentRegion.getType() == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.NAME") break;
        }
    }

    public boolean supports(String feature, String version) {
        return false;
    }
}

