/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.application.internal.operations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.J2EEUtilityJarImportAssistantOperation;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.osgi.util.NLS;

public class LinkArchiveIntoProjectOperation
extends J2EEUtilityJarImportAssistantOperation {
    private String linkedPathVariable;

    public LinkArchiveIntoProjectOperation(File utilityJar, String linkedPathVariable) {
        super(NLS.bind((String)EARCreationResourceHandler.LinkArchiveIntoProjectOperation_Linking_archive_into_selected_proje_, (Object)utilityJar.getName()), utilityJar);
        this.linkedPathVariable = linkedPathVariable;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        MultiStatus status = new MultiStatus("org.eclipse.jst.j2ee", 0, NLS.bind((String)EARCreationResourceHandler.LinkArchiveIntoProjectOperation_Linking_archive_into_selected_proje_, (Object)this.getUtilityJar().getName()), null);
        IProject project = this.getWorkspaceRoot().getProject(this.getAssociatedEARProjectName());
        try {
            IFile linkedJarFile = project.getFile(this.getUtilityJar().getName());
            if (linkedJarFile.exists()) {
                if (this.isOverwriteIfNecessary()) {
                    linkedJarFile.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    status.add(J2EEPlugin.createErrorStatus(0, NLS.bind((String)EARCreationResourceHandler.CreateProjectWithLinkedJarOperation_File_already_exists_0_, (Object)linkedJarFile.getFullPath()), null));
                    return status;
                }
            }
            status.add(this.createLinkedArchive(project, this.getUtilityJar().getName(), this.getUtilityJar(), this.linkedPathVariable, monitor));
            this.addLibraryToClasspath(project, linkedJarFile, monitor);
            this.createVirtualArchiveComponent(project, this.getUtilityJar().getName(), linkedJarFile, monitor);
        }
        catch (CoreException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
        }
        catch (InvocationTargetException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
        }
        catch (InterruptedException e) {
            status.add(J2EEPlugin.createErrorStatus(0, e.getMessage(), e));
        }
        return status;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return Status.CANCEL_STATUS;
    }
}

