/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.dialogs;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.swt.widgets.Shell;

public class ChangeLibDirDialog
extends InputDialog {
    private boolean warnBlank;

    public ChangeLibDirDialog(Shell parentShell, String initialValue, boolean warnBlank) {
        super(parentShell, J2EEUIMessages.getResourceString("CHANGE_LIB_DIR_HEAD"), J2EEUIMessages.getResourceString("NEW_LIB_DIR_PROPMPT"), initialValue, null);
        this.warnBlank = warnBlank;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            String res = this.getText().getText().trim();
            if (res.length() == 0) {
                if (this.warnBlank && !MessageDialog.openQuestion((Shell)this.getShell(), (String)J2EEUIMessages.getResourceString("BLANK_LIB_DIR"), (String)J2EEUIMessages.getResourceString("BLANK_LIB_DIR_CONFIRM"))) {
                    return;
                }
            } else {
                if (res.startsWith("/")) {
                    MessageDialog.openError(null, (String)J2EEUIMessages.getResourceString("INVALID_PATH"), (String)J2EEUIMessages.getResourceString("INVALID_PATH_STARTS_WITH_SLASH_MSG"));
                    return;
                }
                String[] segments = res.split("/");
                Path p = new Path("");
                boolean valid = true;
                int i = 0;
                while (i < segments.length) {
                    valid = p.isValidSegment(segments[i]);
                    if (!valid) break;
                    ++i;
                }
                if (!valid) {
                    MessageDialog.openError(null, (String)J2EEUIMessages.getResourceString("INVALID_PATH"), (String)J2EEUIMessages.getResourceString("INVALID_PATH_MSG"));
                    return;
                }
            }
        }
        super.buttonPressed(buttonId);
    }
}

