/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.core.internal;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.internet.monitor.core.internal.IProtocolAdapter;
import org.eclipse.wst.internet.monitor.core.internal.ProtocolAdapterDelegate;
import org.eclipse.wst.internet.monitor.core.internal.Trace;
import org.eclipse.wst.internet.monitor.core.internal.provisional.IMonitor;

public class ProtocolAdapter
implements IProtocolAdapter {
    protected IConfigurationElement element;
    protected ProtocolAdapterDelegate delegate;

    protected ProtocolAdapter(IConfigurationElement element) {
        this.element = element;
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    protected ProtocolAdapterDelegate getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        try {
            this.delegate = (ProtocolAdapterDelegate)this.element.createExecutableExtension("class");
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not create protocol adapter delegate: " + this.getId(), e);
        }
        return this.delegate;
    }

    public void connect(IMonitor monitor, Socket in, Socket out) throws IOException {
        this.getDelegate().connect(monitor, in, out);
    }

    public void disconnect(IMonitor monitor) throws IOException {
        this.getDelegate().disconnect(monitor);
    }
}

