/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.LibraryOperation;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.registry.TLDTagRegistry;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;

class LibraryOperationFactory {
    private final TLDTagRegistry _tagRegistry;

    public LibraryOperationFactory(TLDTagRegistry tagRegistry) {
        this._tagRegistry = tagRegistry;
    }

    LibraryOperation createAddOperation(ITaglibRecord changeRecord) {
        return new AddTagLibrary(this._tagRegistry, changeRecord);
    }

    LibraryOperation createRemoveOperation(ITaglibRecord changeRecord) {
        return new RemoveTagLibrary(this._tagRegistry, changeRecord);
    }

    LibraryOperation createChangeOperation(ITaglibRecord changeRecord) {
        if (changeRecord == null) {
            throw new IllegalArgumentException();
        }
        return new ChangeTagLibrary(this._tagRegistry, changeRecord);
    }

    private static class AddTagLibrary
    extends LibraryOperation {
        private final TLDTagRegistry _tagRegistry;

        public AddTagLibrary(TLDTagRegistry tagRegistry, ITaglibRecord newRecord) {
            super(newRecord);
            this._tagRegistry = tagRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus doRun() {
            TLDTagRegistry tLDTagRegistry = this._tagRegistry;
            synchronized (tLDTagRegistry) {
                this._tagRegistry.initialize(this._changeRecord, true);
                return Status.OK_STATUS;
            }
        }
    }

    private static class ChangeTagLibrary
    extends LibraryOperation {
        private final TLDTagRegistry _tagRegistry;

        protected ChangeTagLibrary(TLDTagRegistry tagRegistry, ITaglibRecord changeRecord) {
            super(changeRecord);
            this._tagRegistry = tagRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus doRun() {
            IStatus result = null;
            TLDTagRegistry tLDTagRegistry = this._tagRegistry;
            synchronized (tLDTagRegistry) {
                result = new RemoveTagLibrary(this._tagRegistry, this._changeRecord).doRun();
                if (result.getSeverity() != 4 && result.getSeverity() != 8) {
                    result = new AddTagLibrary(this._tagRegistry, this._changeRecord).doRun();
                }
            }
            return result;
        }
    }

    private static class RemoveTagLibrary
    extends LibraryOperation {
        private final TLDTagRegistry _tagRegistry;

        protected RemoveTagLibrary(TLDTagRegistry tagRegistry, ITaglibRecord changeRecord) {
            super(changeRecord);
            this._tagRegistry = tagRegistry;
        }

        protected IStatus doRun() {
            this._tagRegistry.remove(this._changeRecord);
            return Status.OK_STATUS;
        }
    }
}

