/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.componentcore;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.componentcore.AppClientBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.EJBBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.EnterpriseBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.JCABinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentLoadAdapter;
import org.eclipse.jst.j2ee.internal.componentcore.UtilityBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.componentcore.WebBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.javaee.applicationclient.ApplicationClient;
import org.eclipse.jst.javaee.applicationclient.ApplicationclientFactory;
import org.eclipse.jst.javaee.core.DisplayName;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EjbFactory;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.javaee.web.WebFactory;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.ArchiveOpenFailureException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.BinaryComponentHelper;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class JavaEEBinaryComponentHelper
extends BinaryComponentHelper {
    private IArchive archive;
    private EnterpriseBinaryComponentHelper legacyBinaryHelper;
    private int localArchiveAccessCount = 0;
    private int preSwapAccessCount = 0;

    public static JavaEEQuickPeek getJavaEEQuickPeek(IVirtualComponent aBinaryComponent) {
        JavaEEBinaryComponentHelper helper = null;
        try {
            JavaEEQuickPeek qp;
            helper = new JavaEEBinaryComponentHelper(aBinaryComponent);
            IArchive archive = helper.getArchive();
            if (archive == null) {
                JavaEEQuickPeek javaEEQuickPeek = new JavaEEQuickPeek(null);
                return javaEEQuickPeek;
            }
            JavaEEQuickPeek javaEEQuickPeek = qp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(archive);
            return javaEEQuickPeek;
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    public JavaEEBinaryComponentHelper(IVirtualComponent aBinaryComponent) {
        super(aBinaryComponent);
    }

    public IPath getAbsolutePath() {
        IArchiveLoadAdapter loadAdapter = null;
        loadAdapter = this.getArchive().getArchiveOptions().hasOption((Object)"WRAPPED_LOAD_ADAPTER") ? (IArchiveLoadAdapter)this.getArchive().getArchiveOptions().getOption((Object)"WRAPPED_LOAD_ADAPTER") : (IArchiveLoadAdapter)this.getArchive().getArchiveOptions().getOption((Object)"LOAD_ADAPTER");
        return ((JavaEEBinaryComponentLoadAdapter)loadAdapter).getArchivePath();
    }

    public EObject getPrimaryRootObject() {
        JavaEEQuickPeek qp = JavaEEArchiveUtilities.INSTANCE.getJavaEEQuickPeek(this.getArchive());
        Path ddPath = null;
        switch (qp.getType()) {
            case 3: {
                ddPath = new Path("META-INF/application-client.xml");
                break;
            }
            case 0: {
                ddPath = new Path("META-INF/ejb-jar.xml");
                break;
            }
            case 4: {
                ddPath = new Path("WEB-INF/web.xml");
                break;
            }
            case 2: {
                ddPath = new Path("META-INF/ra.xml");
            }
        }
        if (ddPath != null) {
            if (this.getArchive().containsArchiveResource((IPath)ddPath)) {
                try {
                    return (EObject)this.getArchive().getModelObject((IPath)ddPath);
                }
                catch (ArchiveModelLoadException e) {
                    J2EEPlugin.logError(e);
                }
            } else {
                IVirtualReference[] refs;
                String displayName = this.getComponent().getName();
                IVirtualComponent earComponent = ComponentCore.createComponent((IProject)this.getComponent().getProject());
                IVirtualReference[] iVirtualReferenceArray = refs = earComponent.getReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IVirtualReference ref = iVirtualReferenceArray[n2];
                    if (ref.getReferencedComponent().equals(this.getComponent())) {
                        displayName = ref.getArchiveName();
                        break;
                    }
                    ++n2;
                }
                DisplayName dn = JavaeeFactory.eINSTANCE.createDisplayName();
                dn.setValue(displayName);
                EObject root = null;
                switch (qp.getType()) {
                    case 3: {
                        ApplicationClient applicationClient = ApplicationclientFactory.eINSTANCE.createApplicationClient();
                        applicationClient.getDisplayNames().add(dn);
                        root = (EObject)applicationClient;
                        break;
                    }
                    case 0: {
                        EJBJar ejbJar = EjbFactory.eINSTANCE.createEJBJar();
                        ejbJar.getDisplayNames().add(dn);
                        root = (EObject)ejbJar;
                        break;
                    }
                    case 4: {
                        WebApp webApp = WebFactory.eINSTANCE.createWebApp();
                        webApp.getDisplayNames().add(dn);
                        root = (EObject)webApp;
                    }
                }
                return root;
            }
        }
        return null;
    }

    public Resource getResource(URI uri) {
        Path path = new Path(uri.toString());
        try {
            IArchiveLoadAdapter loadAdapter = null;
            loadAdapter = this.getArchive().getArchiveOptions().hasOption((Object)"WRAPPED_LOAD_ADAPTER") ? (IArchiveLoadAdapter)this.getArchive().getArchiveOptions().getOption((Object)"WRAPPED_LOAD_ADAPTER") : (IArchiveLoadAdapter)this.getArchive().getArchiveOptions().getOption((Object)"LOAD_ADAPTER");
            EObject modelRoot = (EObject)((JavaEEBinaryComponentLoadAdapter)loadAdapter).getModelObject((IPath)path);
            return modelRoot.eResource();
        }
        catch (ArchiveModelLoadException e) {
            J2EEPlugin.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IArchive accessArchive() {
        IArchive archive = this.getArchive();
        if (archive != null) {
            ArchiveCache cache = ArchiveCache.getInstance();
            cache.accessArchive(archive);
            JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
            synchronized (javaEEBinaryComponentHelper) {
                ++this.localArchiveAccessCount;
            }
        }
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safeReleaseArchive(IArchive archive) {
        int count = 0;
        JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
        synchronized (javaEEBinaryComponentHelper) {
            count = this.localArchiveAccessCount;
        }
        if (count > 0) {
            this.releaseArchive(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseArchive(IArchive archive) {
        if (archive != this.archive) {
            throw new RuntimeException("The IArchive parameter must be the same IArchive retrieved from accessArchive");
        }
        if (archive != null) {
            ArchiveCache cache = ArchiveCache.getInstance();
            cache.releaseArchive(archive);
            JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
            synchronized (javaEEBinaryComponentHelper) {
                --this.localArchiveAccessCount;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void preFileSwap() {
        count = 0;
        var2_2 = this;
        synchronized (var2_2) {
            count = this.preSwapAccessCount = this.localArchiveAccessCount;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl13
        }
        do {
            --count;
            this.releaseArchive(this.archive);
lbl13:
            // 2 sources

        } while (count > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void postFileSwap() {
        count = 0;
        var2_2 = this;
        synchronized (var2_2) {
            count = this.preSwapAccessCount;
            this.preSwapAccessCount = 0;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl15
        }
        do {
            --count;
            this.accessArchive();
lbl15:
            // 2 sources

        } while (count > 0);
    }

    public Archive accessLegacyArchive() {
        if (this.legacyBinaryHelper == null) {
            JavaEEQuickPeek qp = JavaEEBinaryComponentHelper.getJavaEEQuickPeek(this.getComponent());
            switch (qp.getType()) {
                case 3: {
                    this.legacyBinaryHelper = new AppClientBinaryComponentHelper(this.getComponent()){

                        protected void aboutToClose() {
                            JavaEEBinaryComponentHelper.this.safeReleaseArchive(JavaEEBinaryComponentHelper.this.archive);
                        }

                        protected void preCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.preFileSwap();
                        }

                        protected void postCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.postFileSwap();
                        }
                    };
                    break;
                }
                case 0: {
                    this.legacyBinaryHelper = new EJBBinaryComponentHelper(this.getComponent()){

                        protected void aboutToClose() {
                            JavaEEBinaryComponentHelper.this.safeReleaseArchive(JavaEEBinaryComponentHelper.this.archive);
                        }

                        protected void preCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.preFileSwap();
                        }

                        protected void postCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.postFileSwap();
                        }
                    };
                    break;
                }
                case 4: {
                    this.legacyBinaryHelper = new WebBinaryComponentHelper(this.getComponent()){

                        protected void aboutToClose() {
                            JavaEEBinaryComponentHelper.this.safeReleaseArchive(JavaEEBinaryComponentHelper.this.archive);
                        }

                        protected void preCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.preFileSwap();
                        }

                        protected void postCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.postFileSwap();
                        }
                    };
                    break;
                }
                case 2: {
                    this.legacyBinaryHelper = new JCABinaryComponentHelper(this.getComponent()){

                        protected void aboutToClose() {
                            JavaEEBinaryComponentHelper.this.safeReleaseArchive(JavaEEBinaryComponentHelper.this.archive);
                        }

                        protected void preCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.preFileSwap();
                        }

                        protected void postCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.postFileSwap();
                        }
                    };
                    break;
                }
                default: {
                    this.legacyBinaryHelper = new UtilityBinaryComponentHelper(this.getComponent()){

                        protected void aboutToClose() {
                            JavaEEBinaryComponentHelper.this.safeReleaseArchive(JavaEEBinaryComponentHelper.this.archive);
                        }

                        protected void preCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.preFileSwap();
                        }

                        protected void postCleanupAfterTempSave(String uri, File original, File destinationFile) {
                            JavaEEBinaryComponentHelper.this.postFileSwap();
                        }
                    };
                }
            }
        }
        this.accessArchive();
        Archive legacyArchive = this.legacyBinaryHelper.accessArchive();
        return legacyArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        EnterpriseBinaryComponentHelper.IReferenceCountedArchive legacyArchive;
        super.dispose();
        int count = 0;
        JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
        synchronized (javaEEBinaryComponentHelper) {
            count = this.localArchiveAccessCount;
        }
        if (count > 0 && this.archive != null) {
            ArchiveCache cache = ArchiveCache.getInstance();
            int i = 0;
            while (i < count) {
                cache.releaseArchive(this.archive);
                JavaEEBinaryComponentHelper javaEEBinaryComponentHelper2 = this;
                synchronized (javaEEBinaryComponentHelper2) {
                    --this.localArchiveAccessCount;
                }
                ++i;
            }
        }
        if (this.legacyBinaryHelper != null && (legacyArchive = this.legacyBinaryHelper.archive) != null) {
            legacyArchive.forceClose();
        }
    }

    protected IArchive getArchive() {
        if (this.archive == null) {
            this.archive = this.getUniqueArchive();
        }
        return this.archive;
    }

    protected IArchive getUniqueArchive() {
        try {
            return this.openArchive();
        }
        catch (ArchiveOpenFailureException e) {
            J2EEPlugin.logError(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IArchive openArchive() throws ArchiveOpenFailureException {
        ArchiveCache cache = ArchiveCache.getInstance();
        IArchive archive = cache.getArchive(this.getComponent());
        if (archive == null) {
            archive = cache.openArchive(this);
        }
        if (archive != null) {
            cache.accessArchive(archive);
            JavaEEBinaryComponentHelper javaEEBinaryComponentHelper = this;
            synchronized (javaEEBinaryComponentHelper) {
                ++this.localArchiveAccessCount;
            }
        }
        return archive;
    }

    public static void clearDisconnectedArchivesInEAR(IVirtualComponent earComponent) {
        ArchiveCache.getInstance().clearDisconnectedArchivesInEAR(earComponent);
    }

    public static void clearAllArchivesInProject(IProject earProject) {
        ArchiveCache.getInstance().clearAllArchivesInProject(earProject);
    }

    private static class ArchiveCache {
        private static ArchiveCache instance = null;
        protected Map<IVirtualComponent, IArchive> componentsToArchives = new Hashtable<IVirtualComponent, IArchive>();
        protected Map<IArchive, Integer> archiveAccessCount = new Hashtable<IArchive, Integer>();

        private ArchiveCache() {
        }

        public static ArchiveCache getInstance() {
            if (instance == null) {
                instance = new ArchiveCache();
            }
            return instance;
        }

        public synchronized void accessArchive(IArchive archive) {
            Integer count = this.archiveAccessCount.get(archive);
            Integer newCount = new Integer(count + 1);
            this.archiveAccessCount.put(archive, newCount);
            if (newCount == 1) {
                JavaEEBinaryComponentLoadAdapter binaryAdapter = null;
                binaryAdapter = archive.getArchiveOptions().hasOption((Object)"WRAPPED_LOAD_ADAPTER") ? (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"WRAPPED_LOAD_ADAPTER")) : (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"LOAD_ADAPTER"));
                if (!binaryAdapter.isPhysicallyOpen()) {
                    try {
                        binaryAdapter.physicallyOpen();
                    }
                    catch (ZipException e) {
                        J2EEPlugin.logError(e);
                    }
                    catch (IOException e) {
                        J2EEPlugin.logError(e);
                    }
                }
            }
        }

        public synchronized void releaseArchive(IArchive archive) {
            Integer count = this.archiveAccessCount.get(archive);
            Integer newCount = new Integer(count - 1);
            this.archiveAccessCount.put(archive, newCount);
            if (newCount == 0) {
                JavaEEBinaryComponentLoadAdapter binaryAdapter = null;
                binaryAdapter = archive.getArchiveOptions().hasOption((Object)"WRAPPED_LOAD_ADAPTER") ? (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"WRAPPED_LOAD_ADAPTER")) : (JavaEEBinaryComponentLoadAdapter)((Object)archive.getArchiveOptions().getOption((Object)"LOAD_ADAPTER"));
                if (binaryAdapter.isPhysicallyOpen()) {
                    binaryAdapter.physicallyClose();
                }
            }
        }

        public synchronized IArchive getArchive(IVirtualComponent component) {
            IArchive archive = this.componentsToArchives.get(component);
            return archive;
        }

        public synchronized void clearDisconnectedArchivesInEAR(IVirtualComponent earComponent) {
            if (this.componentsToArchives.isEmpty()) {
                return;
            }
            HashSet<IVirtualComponent> liveBinaryComponnts = new HashSet<IVirtualComponent>();
            IVirtualReference[] refs = earComponent.getReferences();
            IVirtualComponent component = null;
            int i = 0;
            while (i < refs.length) {
                component = refs[i].getReferencedComponent();
                if (component.isBinary()) {
                    liveBinaryComponnts.add(component);
                }
                ++i;
            }
            this.clearArchivesInProject(earComponent.getProject(), liveBinaryComponnts);
        }

        public synchronized void clearAllArchivesInProject(IProject earProject) {
            if (this.componentsToArchives.isEmpty()) {
                return;
            }
            this.clearArchivesInProject(earProject, null);
        }

        private void clearArchivesInProject(IProject earProject, Set excludeSet) {
            Iterator<Map.Entry<IVirtualComponent, IArchive>> iterator = this.componentsToArchives.entrySet().iterator();
            IVirtualComponent component = null;
            IArchive archive = null;
            while (iterator.hasNext()) {
                Map.Entry<IVirtualComponent, IArchive> entry = iterator.next();
                component = entry.getKey();
                if (!component.getProject().equals((Object)earProject) || excludeSet != null && excludeSet.contains(component)) continue;
                archive = entry.getValue();
                IArchiveFactory.INSTANCE.closeArchive(archive);
                iterator.remove();
                this.archiveAccessCount.remove(archive);
            }
        }

        public synchronized IArchive openArchive(JavaEEBinaryComponentHelper helper) throws ArchiveOpenFailureException {
            IArchive archive = JavaEEArchiveUtilities.INSTANCE.openArchive(helper.getComponent());
            this.componentsToArchives.put(helper.getComponent(), archive);
            this.archiveAccessCount.put(archive, new Integer(0));
            return archive;
        }
    }
}

