/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.builder.IDependencyGraph;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraphImpl
implements IDependencyGraph {
    private Object graphLock = new Object();
    private Map<IProject, Set<IProject>> graph = null;
    private long modStamp = 0L;
    private Map<String, Object> referenceOptions = new HashMap<String, Object>();
    private static DependencyGraphImpl instance = null;
    private DependencyGraphResourceChangedListener listener = null;
    public static final Object GRAPH_UPDATE_JOB_FAMILY = new Object();
    private static final int JOB_DELAY = 100;
    private final GraphUpdateJob graphUpdateJob = new GraphUpdateJob();
    private final Object jobLock = new Object();
    private int pauseCount = 0;

    static IDependencyGraph getInstance() {
        if (instance == null) {
            instance = new DependencyGraphImpl();
            instance.initGraph();
        }
        return instance;
    }

    private DependencyGraphImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getModStamp() {
        Object object = this.graphLock;
        synchronized (object) {
            return this.modStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IProject> getReferencingComponents(IProject targetProject) {
        this.waitForAllUpdates(null);
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> set = this.graph.get(targetProject);
            if (set == null) {
                return Collections.EMPTY_SET;
            }
            Iterator<IProject> iterator = set.iterator();
            while (iterator.hasNext()) {
                IProject project = iterator.next();
                if (project.isAccessible()) continue;
                iterator.remove();
            }
            HashSet<IProject> copy = new HashSet<IProject>();
            copy.addAll(set);
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGraph() {
        Object object = this.graphLock;
        synchronized (object) {
            this.referenceOptions.put("GET_JAVA_REFS", Boolean.FALSE);
            this.referenceOptions.put("GET_FUZZY_EAR_REFS", Boolean.FALSE);
            try {
                IProject[] allProjects;
                this.preUpdate();
                this.graph = new HashMap<IProject, Set<IProject>>();
                this.listener = new DependencyGraphResourceChangedListener();
                ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener, 1);
                IProject[] iProjectArray = allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = allProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject sourceProject = iProjectArray[n2];
                    this.queueProjectAdded(sourceProject);
                    ++n2;
                }
            }
            finally {
                this.postUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllReferences(IProject project) {
        Object object = this.graphLock;
        synchronized (object) {
            this.graph.remove(project);
            Iterator<Set<IProject>> iterator = this.graph.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().remove(project);
            }
            ++this.modStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReference(IProject sourceProject, IProject targetProject) {
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> referencingProjects = this.graph.get(targetProject);
            if (referencingProjects != null) {
                referencingProjects.remove(sourceProject);
            }
            ++this.modStamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReference(IProject sourceProject, IProject targetProject) {
        Object object = this.graphLock;
        synchronized (object) {
            Set<IProject> referencingProjects = this.graph.get(targetProject);
            if (referencingProjects == null) {
                referencingProjects = new HashSet<IProject>();
                this.graph.put(targetProject, referencingProjects);
            }
            referencingProjects.add(sourceProject);
            ++this.modStamp;
        }
    }

    public void queueProjectAdded(IProject project) {
        this.update(project, 1);
    }

    public void queueProjectDeleted(IProject project) {
        this.update(project, 2);
    }

    @Override
    public void update(IProject project) {
        this.update(project, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IProject project, int updateType) {
        switch (updateType) {
            case 0: {
                this.graphUpdateJob.queueProjectUpdated(project);
                break;
            }
            case 1: {
                this.graphUpdateJob.queueProjectAdded(project);
                break;
            }
            case 2: {
                this.graphUpdateJob.queueProjectDeleted(project);
            }
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.graphUpdateJob.schedule(100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preUpdate() {
        Object object = this.jobLock;
        synchronized (object) {
            ++this.pauseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postUpdate() {
        Object object = this.jobLock;
        synchronized (object) {
            if (this.pauseCount > 0) {
                --this.pauseCount;
            }
            if (this.pauseCount > 0) {
                return;
            }
        }
        this.graphUpdateJob.schedule(100L);
    }

    public void waitForAllUpdates(IProgressMonitor monitor) {
        Thread graphUpdateThread = this.graphUpdateJob.getThread();
        if (graphUpdateThread != null && graphUpdateThread != Thread.currentThread()) {
            try {
                this.graphUpdateJob.join();
            }
            catch (InterruptedException e) {
                ModulecorePlugin.logError(e);
            }
        }
        if (this.graphUpdateJob.shouldSchedule()) {
            this.graphUpdateJob.run(monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.graphLock;
        synchronized (object) {
            StringBuffer buff = new StringBuffer("Dependency Graph:\n{\n");
            for (Map.Entry<IProject, Set<IProject>> entry : this.graph.entrySet()) {
                buff.append("  " + entry.getKey().getName() + " -> {");
                Iterator<IProject> mappedProjects = entry.getValue().iterator();
                while (mappedProjects.hasNext()) {
                    buff.append(mappedProjects.next().getName());
                    if (!mappedProjects.hasNext()) continue;
                    buff.append(", ");
                }
                buff.append("}\n");
            }
            buff.append("}");
            return buff.toString();
        }
    }

    private class DependencyGraphResourceChangedListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private DependencyGraphResourceChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                try {
                    DependencyGraphImpl.this.preUpdate();
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    ModulecorePlugin.logError(e);
                    DependencyGraphImpl.this.postUpdate();
                }
            }
            finally {
                DependencyGraphImpl.this.postUpdate();
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    int kind = delta.getKind();
                    if ((1 & kind) != 0) {
                        DependencyGraphImpl.this.queueProjectAdded((IProject)resource);
                        return false;
                    }
                    if ((2 & kind) != 0) {
                        DependencyGraphImpl.this.queueProjectDeleted((IProject)resource);
                        return false;
                    }
                    if ((4 & kind) != 0) {
                        int flags = delta.getFlags();
                        if ((0x4000 & flags) != 0) {
                            boolean isOpen = ((IProject)resource).isOpen();
                            if (isOpen) {
                                DependencyGraphImpl.this.queueProjectAdded((IProject)resource);
                            } else {
                                DependencyGraphImpl.this.queueProjectDeleted((IProject)resource);
                            }
                            return false;
                        }
                        return true;
                    }
                    return false;
                }
                case 2: {
                    return resource.getName().equals(".settings");
                }
                case 1: {
                    String name = resource.getName();
                    if (!name.equals("org.eclipse.wst.common.component")) break;
                    DependencyGraphImpl.this.update(resource.getProject());
                }
            }
            return false;
        }
    }

    private class GraphUpdateJob
    extends Job {
        private Queue projectsAdded;
        private Queue projectsRemoved;
        private Queue projectsUpdated;

        public GraphUpdateJob() {
            super("Graph Update Job");
            this.projectsAdded = new Queue();
            this.projectsRemoved = new Queue();
            this.projectsUpdated = new Queue();
            this.setSystem(true);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public boolean belongsTo(Object family) {
            if (family == GRAPH_UPDATE_JOB_FAMILY) {
                return true;
            }
            return super.belongsTo(family);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueProjectAdded(IProject project) {
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            this.projectsAdded.add(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueProjectDeleted(IProject project) {
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            this.projectsRemoved.add(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueProjectUpdated(IProject project) {
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            this.projectsUpdated.add(project);
        }

        public boolean shouldSchedule() {
            boolean isEmpty = this.projectsAdded.isEmpty() && this.projectsRemoved.isEmpty() && this.projectsUpdated.isEmpty();
            return !isEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            final Object[] removed = this.projectsRemoved.getListeners();
            final Object[] updated = this.projectsUpdated.getListeners();
            final Object[] added = this.projectsAdded.getListeners();
            if (removed.length == 0 && updated.length == 0 && added.length == 0) {
                return Status.OK_STATUS;
            }
            Object object = DependencyGraphImpl.this.graphLock;
            synchronized (object) {
                DependencyGraphImpl dependencyGraphImpl = DependencyGraphImpl.this;
                dependencyGraphImpl.modStamp = dependencyGraphImpl.modStamp + 1L;
            }
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    ModulecorePlugin.logError(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws Exception {
                    block20: {
                        IProject[] allProjects;
                        int n;
                        block19: {
                            int n2;
                            Object[] objectArray;
                            Object object = DependencyGraphImpl.this.graphLock;
                            synchronized (object) {
                                objectArray = removed;
                                n = removed.length;
                                n2 = 0;
                                while (n2 < n) {
                                    Object o = objectArray[n2];
                                    IProject project = (IProject)o;
                                    DependencyGraphImpl.this.removeAllReferences(project);
                                    ++n2;
                                }
                            }
                            if (added.length <= 0) break block19;
                            allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                            objectArray = allProjects;
                            n = allProjects.length;
                            n2 = 0;
                            while (n2 < n) {
                                Object sourceProject = objectArray[n2];
                                IVirtualComponent component = ComponentCore.createComponent((IProject)sourceProject);
                                if (component != null) {
                                    IVirtualReference[] references;
                                    IVirtualReference[] iVirtualReferenceArray = references = component instanceof VirtualComponent ? ((VirtualComponent)component).getReferences(DependencyGraphImpl.this.referenceOptions) : component.getReferences();
                                    int n3 = references.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        IProject targetProject;
                                        IVirtualReference ref = iVirtualReferenceArray[n4];
                                        IVirtualComponent targetComponent = ref.getReferencedComponent();
                                        if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals(sourceProject)) {
                                            DependencyGraphImpl.this.addReference((IProject)sourceProject, targetProject);
                                        }
                                        ++n4;
                                    }
                                }
                                ++n2;
                            }
                            break block20;
                        }
                        if (updated.length <= 0) break block20;
                        allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        HashSet<IProject> validRefs = new HashSet<IProject>();
                        Object[] objectArray = updated;
                        int n5 = updated.length;
                        n = 0;
                        while (n < n5) {
                            Object o = objectArray[n];
                            IProject sourceProject = (IProject)o;
                            IVirtualComponent component = ComponentCore.createComponent(sourceProject);
                            if (component != null) {
                                IVirtualReference[] references;
                                validRefs.clear();
                                IVirtualReference[] iVirtualReferenceArray = references = component instanceof VirtualComponent ? ((VirtualComponent)component).getReferences(DependencyGraphImpl.this.referenceOptions) : component.getReferences();
                                int n6 = references.length;
                                int n7 = 0;
                                while (n7 < n6) {
                                    IProject targetProject;
                                    IVirtualReference ref = iVirtualReferenceArray[n7];
                                    IVirtualComponent targetComponent = ref.getReferencedComponent();
                                    if (targetComponent != null && (targetProject = targetComponent.getProject()) != null && !targetProject.equals((Object)sourceProject)) {
                                        validRefs.add(targetProject);
                                    }
                                    ++n7;
                                }
                                Object object = DependencyGraphImpl.this.graphLock;
                                synchronized (object) {
                                    IProject[] iProjectArray = allProjects;
                                    int n8 = allProjects.length;
                                    n6 = 0;
                                    while (n6 < n8) {
                                        IProject targetProject = iProjectArray[n6];
                                        if (validRefs.remove(targetProject)) {
                                            DependencyGraphImpl.this.addReference(sourceProject, targetProject);
                                        } else {
                                            DependencyGraphImpl.this.removeReference(sourceProject, targetProject);
                                        }
                                        ++n6;
                                    }
                                }
                            } else {
                                DependencyGraphImpl.this.removeAllReferences(sourceProject);
                            }
                            ++n;
                        }
                    }
                }
            });
            return Status.OK_STATUS;
        }

        private class Queue
        extends ListenerList {
            private Queue() {
            }

            public synchronized Object[] getListeners() {
                Object[] data = super.getListeners();
                this.clear();
                return data;
            }

            public synchronized boolean isEmpty() {
                return super.isEmpty();
            }
        }
    }
}

