/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class ModulePublishInfo {
    private static final IModuleResource[] EMPTY_MODULE_RESOURCE = new IModuleResource[0];
    private static final IModuleResourceDelta[] EMPTY_MODULE_RESOURCE_DELTA = new IModuleResourceDelta[0];
    private static final String MODULE_ID = "module-ids";
    private static final String NAME = "name";
    private static final String MODULE_TYPE_ID = "module-type-id";
    private static final String MODULE_TYPE_VERSION = "module-type-version";
    private static final String STAMP = "stamp";
    private static final String FILE = "file";
    private static final String FOLDER = "folder";
    private String moduleId;
    private String name;
    private IModuleResource[] resources = EMPTY_MODULE_RESOURCE;
    private IModuleType moduleType;
    private boolean useCache;
    private IModuleResource[] currentResources = null;
    private IModuleResourceDelta[] delta = null;
    private boolean hasDelta;
    static /* synthetic */ Class class$0;

    public ModulePublishInfo(String moduleId, String name, IModuleType moduleType) {
        this.moduleId = moduleId;
        this.name = name;
        this.moduleType = moduleType;
    }

    public ModulePublishInfo(IMemento memento) {
        this.load(memento);
    }

    public ModulePublishInfo(DataInput in) throws IOException {
        this.load(in);
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.name;
    }

    public IModuleType getModuleType() {
        return this.moduleType;
    }

    public IModuleResource[] getResources() {
        return this.resources;
    }

    public void setResources(IModuleResource[] res) {
        this.resources = res;
    }

    protected void load(IMemento memento) {
        Trace.trace(5, "Loading module publish info for: " + memento);
        try {
            this.moduleId = memento.getString(MODULE_ID);
            this.name = memento.getString(NAME);
            String mt = memento.getString(MODULE_TYPE_ID);
            String mv = memento.getString(MODULE_TYPE_VERSION);
            if (mt != null && mt.length() > 0) {
                this.moduleType = ModuleType.getModuleType(mt, mv);
            }
            this.resources = this.loadResource(memento, (IPath)new Path(""));
        }
        catch (Exception e) {
            Trace.trace(2, "Could not load module publish info information: " + e.getMessage());
        }
    }

    protected IModuleResource[] loadResource(IMemento memento, IPath path) {
        String name2;
        int i;
        int size;
        if (memento == null) {
            return EMPTY_MODULE_RESOURCE;
        }
        ArrayList<IModuleResource> list = new ArrayList<IModuleResource>(10);
        IMemento[] children = memento.getChildren(FILE);
        if (children != null) {
            size = children.length;
            i = 0;
            while (i < size) {
                name2 = children[i].getString(NAME);
                long stamp = Long.parseLong(children[i].getString(STAMP));
                ModuleFile file = new ModuleFile(name2, path, stamp);
                list.add(file);
                ++i;
            }
        }
        if ((children = memento.getChildren(FOLDER)) != null) {
            size = children.length;
            i = 0;
            while (i < size) {
                name2 = children[i].getString(NAME);
                ModuleFolder folder = new ModuleFolder(null, name2, path);
                folder.setMembers(this.loadResource(children[i], path.append(name2)));
                list.add(folder);
                ++i;
            }
        }
        IModuleResource[] resources2 = new IModuleResource[list.size()];
        list.toArray(resources2);
        return resources2;
    }

    protected void load(DataInput in) throws IOException {
        Trace.trace(5, "Loading module publish info");
        this.moduleId = in.readUTF();
        byte b = in.readByte();
        this.name = (b & 1) != 0 ? in.readUTF() : null;
        if ((b & 2) != 0) {
            String mt = in.readUTF();
            String mv = in.readUTF();
            if (mt != null && mt.length() > 0) {
                this.moduleType = ModuleType.getModuleType(mt, mv);
            }
        } else {
            this.moduleType = null;
        }
        this.resources = this.loadResource(in, (IPath)new Path(""));
    }

    private IModuleResource[] loadResource(DataInput in, IPath path) throws IOException {
        int size = in.readInt();
        if (size > 1000000) {
            throw new IOException("Folder capacity limit reached");
        }
        IModuleResource[] resources2 = new IModuleResource[size];
        int i = 0;
        while (i < size) {
            String name2;
            byte b = in.readByte();
            if (b == 0) {
                name2 = in.readUTF();
                long stamp = in.readLong();
                resources2[i] = new ModuleFile(name2, path, stamp);
            } else if (b == 1) {
                name2 = in.readUTF();
                ModuleFolder folder = new ModuleFolder(null, name2, path);
                folder.setMembers(this.loadResource(in, path.append(name2)));
                resources2[i] = folder;
            }
            ++i;
        }
        return resources2;
    }

    protected void save(DataOutput out) {
        try {
            out.writeUTF(this.moduleId);
            byte b = 0;
            if (this.name != null) {
                b = (byte)(b | 1);
            }
            if (this.moduleType != null) {
                b = (byte)(b | 2);
            }
            out.writeByte(b);
            if (this.name != null) {
                out.writeUTF(this.name);
            }
            if (this.moduleType != null) {
                out.writeUTF(this.moduleType.getId());
                out.writeUTF(this.moduleType.getVersion());
            }
            this.saveResource(out, this.resources);
        }
        catch (Exception e) {
            Trace.trace(3, "Could not save module publish info", e);
        }
    }

    protected void saveResource(DataOutput out, IModuleResource[] resources2) throws IOException {
        if (resources2 == null) {
            return;
        }
        int size = resources2.length;
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            if (resources2[i] instanceof IModuleFile) {
                IModuleFile file = (IModuleFile)resources2[i];
                out.writeByte(0);
                out.writeUTF(file.getName());
                out.writeLong(file.getModificationStamp());
            } else {
                IModuleFolder folder = (IModuleFolder)resources2[i];
                out.writeByte(1);
                out.writeUTF(folder.getName());
                IModuleResource[] resources3 = folder.members();
                this.saveResource(out, resources3);
            }
            ++i;
        }
    }

    protected void startCaching() {
        this.useCache = true;
        this.currentResources = null;
        this.delta = null;
        this.hasDelta = false;
    }

    private void fillCache(IModule[] module) {
        if (!this.useCache) {
            return;
        }
        if (this.currentResources != null) {
            return;
        }
        try {
            ModuleDelegate pm;
            long time = System.currentTimeMillis();
            IModule m = module[module.length - 1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.currentResources = (pm = (ModuleDelegate)m.loadAdapter(clazz, null)) == null || m.getProject() != null && !m.getProject().isAccessible() ? EMPTY_MODULE_RESOURCE : pm.members();
            this.delta = ServerPublishInfo.getDelta(this.resources, this.currentResources);
            this.hasDelta = this.delta != null && this.delta.length > 0;
            Trace.trace(10, "Filling publish cache for " + m.getName() + ": " + (System.currentTimeMillis() - time));
        }
        catch (CoreException coreException) {
            Trace.trace(2, "Couldn't fill publish cache for " + module);
        }
        if (this.delta == null) {
            this.delta = EMPTY_MODULE_RESOURCE_DELTA;
        }
    }

    protected void clearCache() {
        this.useCache = false;
        this.currentResources = null;
        this.delta = null;
        this.hasDelta = false;
    }

    protected IModuleResource[] getModuleResources(IModule[] module) {
        ModuleDelegate pm;
        if (module == null) {
            return EMPTY_MODULE_RESOURCE;
        }
        if (this.useCache) {
            this.fillCache(module);
            return this.currentResources;
        }
        int size = module.length;
        IModule m = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((pm = (ModuleDelegate)m.loadAdapter(clazz, null)) == null || m.getProject() != null && !m.getProject().isAccessible()) {
            return EMPTY_MODULE_RESOURCE;
        }
        try {
            long time = System.currentTimeMillis();
            IModuleResource[] x = pm.members();
            Trace.trace(10, "Time to get members() for " + module[size - 1].getName() + ": " + (System.currentTimeMillis() - time));
            return x;
        }
        catch (CoreException ce) {
            Trace.trace(2, "Possible failure in getModuleResources", ce);
            return EMPTY_MODULE_RESOURCE;
        }
    }

    protected IModuleResourceDelta[] getDelta(IModule[] module) {
        ModuleDelegate pm;
        if (module == null) {
            return EMPTY_MODULE_RESOURCE_DELTA;
        }
        if (this.useCache) {
            this.fillCache(module);
            return this.delta;
        }
        IModule m = module[module.length - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((pm = (ModuleDelegate)m.loadAdapter(clazz, null)) == null || m.getProject() != null && !m.getProject().isAccessible()) {
            return EMPTY_MODULE_RESOURCE_DELTA;
        }
        IModuleResource[] resources2 = null;
        try {
            resources2 = pm.members();
        }
        catch (CoreException ce) {
            Trace.trace(2, "Possible failure in getDelta", ce);
        }
        if (resources2 == null) {
            resources2 = EMPTY_MODULE_RESOURCE;
        }
        return ServerPublishInfo.getDelta(this.getResources(), resources2);
    }

    protected boolean hasDelta(IModule[] module) {
        if (module == null) {
            return false;
        }
        if (this.useCache) {
            this.fillCache(module);
            return this.hasDelta;
        }
        IModule m = module[module.length - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)m.loadAdapter(clazz, null);
        IModuleResource[] resources2 = null;
        if (pm == null || m.getProject() != null && !m.getProject().isAccessible()) {
            return false;
        }
        try {
            resources2 = pm.members();
        }
        catch (CoreException ce) {
            Trace.trace(2, "Possible failure in hasDelta", ce);
        }
        if (resources2 == null) {
            resources2 = EMPTY_MODULE_RESOURCE;
        }
        return ServerPublishInfo.hasDelta(this.getResources(), resources2);
    }

    public void fill(IModule[] module) {
        ModuleDelegate pm;
        if (module == null) {
            return;
        }
        if (this.useCache) {
            this.fillCache(module);
            this.setResources(this.currentResources);
            return;
        }
        IModule m = module[module.length - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((pm = (ModuleDelegate)m.loadAdapter(clazz, null)) == null || m.getProject() != null && !m.getProject().isAccessible()) {
            this.setResources(EMPTY_MODULE_RESOURCE);
            return;
        }
        try {
            this.setResources(pm.members());
        }
        catch (CoreException ce) {
            Trace.trace(2, "Possible failure in fill", ce);
        }
    }

    protected IModule getDeletedModule() {
        String id = this.moduleId;
        int index = id.lastIndexOf("#");
        if (index > 0) {
            id = id.substring(index + 1);
        }
        return new DeletedModule(id, this.name, this.moduleType);
    }

    public String toString() {
        return "ModulePublishInfo [" + this.moduleId + "]";
    }
}

