/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Map;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionAdapter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManager;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerImpl;

class JDBCManager {
    private static final ConnectionManager manager = RDBCorePlugin.getDefault().getConnectionManager();
    public static final JDBCManager INSTANCE = new JDBCManager();
    private boolean debug = ((ConnectionManagerImpl)manager).isDebugging();

    private void debug(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        }
    }

    private void debug(String statement) {
        if (this.debug) {
            System.out.println(statement);
        }
    }

    private JDBCManager() {
    }

    public Connection createConnection(ConnectionInfo info, Driver driver, Map loaderMap) throws Exception {
        ConnectionThread thread = new ConnectionThread(info, driver, loaderMap);
        return thread.activateConnectionAdapter();
    }

    static interface IConnectionThread
    extends Cloneable {
        public void connect() throws Exception;

        public void startTimeOutProcess() throws SQLException;

        public boolean timeOut() throws SQLException;

        public void interrupt();

        public Connection activateConnectionAdapter() throws Exception;

        public Connection activateConnection(ConnectionAdapter var1) throws Exception;

        public Connection getConnection();

        public void resetConnectionAdapter();

        public boolean isAlive();

        public Object clone();
    }

    private class ConnectionThread
    extends Thread
    implements IConnectionThread {
        private ConnectionInfo info = null;
        private Driver driver = null;
        private Map loaderMap = null;
        private ConnectionAdapter connectionAdapter = null;
        private ConnectionAdapter startAdapter = null;
        private Connection nativeConnection = null;
        private Exception connectionException = null;
        private boolean stopped = false;

        private Connection getNewConnection() throws Exception {
            JDBCManager.this.debug("Create New Connection -> " + this.info.getName());
            Connection cnx = RDBCorePlugin.getDefault().getConnectionFactoryRegistry().getConnectionFactory(this.info.getDriverClassName()).connect(this.driver, (ClassLoader)this.loaderMap.get(this.info.getURL()), this.info);
            JDBCManager.this.debug("*** Open JDBC Connection... *** Connection [" + cnx.toString() + "] - Connection Name -> " + this.info.getName());
            return cnx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Connection waitForConnection() throws Exception {
            ConnectionThread connectionThread = this;
            synchronized (connectionThread) {
                while (this.nativeConnection == null && !this.stopped) {
                    try {
                        this.wait(1000L);
                        JDBCManager.this.debug("Waiting for Connection initialization...");
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.nativeConnection != null) {
                JDBCManager.this.debug("Connection initialized!");
            } else {
                JDBCManager.this.debug("Connection failed to initialize!");
            }
            if (this.connectionException != null) {
                throw this.connectionException;
            }
            return this.getConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void connect() throws Exception {
            try {
                ConnectionThread connectionThread = this;
                synchronized (connectionThread) {
                    Connection cnn = this.getNewConnection();
                    if (this.startAdapter == null) {
                        this.connectionAdapter = new ConnectionAdapter(this.info, cnn);
                        this.connectionAdapter.setConnectionThread(this);
                    } else {
                        this.connectionAdapter = this.startAdapter;
                    }
                    this.info.setTimedOut(false);
                    this.nativeConnection = cnn;
                    this.notifyAll();
                }
            }
            catch (Exception e) {
                this.connectionException = e;
                JDBCManager.this.debug("Connection interruption!");
                this.interrupt();
            }
        }

        public ConnectionThread(ConnectionInfo info, Driver driver, Map loaderMap) {
            JDBCManager.this.debug("New Connection Thread -> " + this.hashCode() + " - " + this.toString());
            this.info = info;
            this.driver = driver;
            this.loaderMap = loaderMap;
        }

        public void resetConnectionAdapter() {
            this.connectionAdapter = null;
        }

        public Object clone() {
            return new ConnectionThread(this.info, this.driver, this.loaderMap);
        }

        public Connection activateConnection(ConnectionAdapter adapter) throws Exception {
            this.startAdapter = adapter;
            this.start();
            this.waitForConnection();
            return this.nativeConnection;
        }

        public Connection activateConnectionAdapter() throws Exception {
            this.start();
            return this.waitForConnection();
        }

        public void interrupt() {
            JDBCManager.this.debug("Interruption in progress for Connection -> " + this.info.getName());
            super.interrupt();
        }

        public synchronized boolean timeOut() throws SQLException {
            return this.connectionAdapter.timeOut();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void startTimeOutProcess() throws SQLException {
            ConnectionThread connectionThread = this;
            synchronized (connectionThread) {
                try {
                    JDBCManager.this.debug("Timed-out requested...");
                    while (!this.timeOut()) {
                        this.wait(1000L);
                    }
                    this.info.setTimedOut(true);
                }
                catch (InterruptedException e) {
                    JDBCManager.this.debug(e);
                }
            }
        }

        public synchronized Connection getConnection() {
            return this.connectionAdapter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.connect();
                int timeout = manager.getTimeout() != 0 ? manager.getTimeout() : manager.getDefaultTimeout();
                ConnectionThread connectionThread = this;
                synchronized (connectionThread) {
                    JDBCManager.this.debug("Start wait...");
                    this.wait(1000 * timeout);
                    JDBCManager.this.debug("Stop wait...");
                    JDBCManager.this.debug("Time expired - Start time out process...");
                    this.startTimeOutProcess();
                }
            }
            catch (InterruptedException e) {
                this.stopped = true;
                JDBCManager.this.debug("*** Wait interrupted! force Close ***");
                JDBCManager.this.debug(e);
                try {
                    if (this.connectionAdapter != null) {
                        this.connectionAdapter.close();
                    }
                }
                catch (SQLException e1) {
                    JDBCManager.this.debug(e1);
                }
            }
            catch (Exception e) {
                JDBCManager.this.debug("*** Run Exception! force Close ***");
                JDBCManager.this.debug(e);
                try {
                    if (this.connectionAdapter != null) {
                        this.connectionAdapter.close();
                    }
                }
                catch (SQLException e1) {
                    JDBCManager.this.debug(e1);
                }
            }
        }
    }
}

