/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.text;

import java.io.IOException;
import java.io.Reader;

public class CharSequenceReader
extends Reader {
    private int fCurrentPosition;
    private int fMaximumReadOffset;
    private CharSequence fOriginalSource;

    CharSequenceReader() {
    }

    public CharSequenceReader(CharSequence originalSource, int offset, int length) {
        this.fOriginalSource = originalSource;
        int startOffset = offset;
        int maxRequestedOffset = startOffset + length;
        int maxPossibleOffset = 0 + originalSource.length();
        this.fMaximumReadOffset = Math.min(maxRequestedOffset, maxPossibleOffset);
        this.fCurrentPosition = startOffset;
    }

    CharSequenceReader(Object lock) {
        super(lock);
    }

    public void close() throws IOException {
    }

    public CharSequence getOriginalSource() {
        return this.fOriginalSource;
    }

    public int read() {
        int result = -1;
        if (this.fCurrentPosition < this.fMaximumReadOffset) {
            result = this.fOriginalSource.charAt(this.fCurrentPosition++);
        }
        return result;
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsToRead = -1;
        if (this.fCurrentPosition < this.fMaximumReadOffset) {
            int buffMaxToRead = cbuf.length - off;
            int minRequested = Math.min(buffMaxToRead, len);
            int lengthRemaining = this.fMaximumReadOffset - this.fCurrentPosition;
            charsToRead = Math.min(minRequested, lengthRemaining);
            CharSequence seq = this.fOriginalSource.subSequence(this.fCurrentPosition, this.fCurrentPosition + charsToRead);
            String seqString = (String)seq;
            seqString.getChars(0, seqString.length(), cbuf, off);
            this.fCurrentPosition += charsToRead;
        }
        return charsToRead;
    }
}

